/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.WorkerSlot;

public class SchedulerAssignmentImpl
implements SchedulerAssignment {
    String topologyId;
    Map<ExecutorDetails, WorkerSlot> executorToSlot;

    public SchedulerAssignmentImpl(String topologyId, Map<ExecutorDetails, WorkerSlot> executorToSlots) {
        this.topologyId = topologyId;
        this.executorToSlot = new HashMap<ExecutorDetails, WorkerSlot>(0);
        if (executorToSlots != null) {
            this.executorToSlot.putAll(executorToSlots);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " topo: " + this.topologyId + " execToSlots: " + this.executorToSlot;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SchedulerAssignmentImpl) {
            SchedulerAssignmentImpl sother = (SchedulerAssignmentImpl)other;
            return this.topologyId.equals(sother.topologyId) && this.executorToSlot.equals(sother.executorToSlot);
        }
        return false;
    }

    @Override
    public Set<WorkerSlot> getSlots() {
        return new HashSet<WorkerSlot>(this.executorToSlot.values());
    }

    public void assign(WorkerSlot slot, Collection<ExecutorDetails> executors) {
        for (ExecutorDetails executor : executors) {
            this.executorToSlot.put(executor, slot);
        }
    }

    public void unassignBySlot(WorkerSlot slot) {
        ArrayList<ExecutorDetails> executors = new ArrayList<ExecutorDetails>();
        for (ExecutorDetails executor : this.executorToSlot.keySet()) {
            WorkerSlot ws = this.executorToSlot.get(executor);
            if (!ws.equals(slot)) continue;
            executors.add(executor);
        }
        for (ExecutorDetails executor : executors) {
            this.executorToSlot.remove(executor);
        }
    }

    @Override
    public boolean isSlotOccupied(WorkerSlot slot) {
        return this.executorToSlot.containsValue(slot);
    }

    @Override
    public boolean isExecutorAssigned(ExecutorDetails executor) {
        return this.executorToSlot.containsKey(executor);
    }

    @Override
    public String getTopologyId() {
        return this.topologyId;
    }

    @Override
    public Map<ExecutorDetails, WorkerSlot> getExecutorToSlot() {
        return this.executorToSlot;
    }

    @Override
    public Set<ExecutorDetails> getExecutors() {
        return this.executorToSlot.keySet();
    }

    @Override
    public Map<WorkerSlot, Collection<ExecutorDetails>> getSlotToExecutors() {
        HashMap<WorkerSlot, Collection<ExecutorDetails>> ret = new HashMap<WorkerSlot, Collection<ExecutorDetails>>();
        for (Map.Entry<ExecutorDetails, WorkerSlot> entry : this.executorToSlot.entrySet()) {
            ExecutorDetails exec = entry.getKey();
            WorkerSlot ws = entry.getValue();
            if (!ret.containsKey(ws)) {
                ret.put(ws, new LinkedList());
            }
            ((Collection)ret.get(ws)).add(exec);
        }
        return ret;
    }
}

