/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.resource.Component;
import org.apache.storm.scheduler.resource.ResourceUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyDetails {
    private String topologyId;
    private Map<String, Object> topologyConf;
    private StormTopology topology;
    private Map<ExecutorDetails, String> executorToComponent;
    private int numWorkers;
    private Map<ExecutorDetails, Map<String, Double>> resourceList;
    private Double topologyWorkerMaxHeapSize;
    private Integer topologyPriority;
    private int launchTime;
    private static final Logger LOG = LoggerFactory.getLogger(TopologyDetails.class);

    public TopologyDetails(String topologyId, Map<String, Object> topologyConf, StormTopology topology, int numWorkers) {
        this(topologyId, topologyConf, topology, numWorkers, null, 0);
    }

    public TopologyDetails(String topologyId, Map<String, Object> topologyConf, StormTopology topology, int numWorkers, Map<ExecutorDetails, String> executorToComponents) {
        this(topologyId, topologyConf, topology, numWorkers, executorToComponents, 0);
    }

    public TopologyDetails(String topologyId, Map<String, Object> topologyConf, StormTopology topology, int numWorkers, Map<ExecutorDetails, String> executorToComponents, int launchTime) {
        this.topologyId = topologyId;
        this.topologyConf = topologyConf;
        this.topology = topology;
        this.numWorkers = numWorkers;
        this.executorToComponent = new HashMap<ExecutorDetails, String>(0);
        if (executorToComponents != null) {
            this.executorToComponent.putAll(executorToComponents);
        }
        if (this.topology != null) {
            this.initResourceList();
        }
        this.initConfigs();
        this.launchTime = launchTime;
    }

    public String getId() {
        return this.topologyId;
    }

    public String getName() {
        return (String)this.topologyConf.get("topology.name");
    }

    public Map getConf() {
        return this.topologyConf;
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public StormTopology getTopology() {
        return this.topology;
    }

    public Map<ExecutorDetails, String> getExecutorToComponent() {
        return this.executorToComponent;
    }

    public Map<ExecutorDetails, String> selectExecutorToComponent(Collection<ExecutorDetails> executors) {
        HashMap<ExecutorDetails, String> ret = new HashMap<ExecutorDetails, String>(executors.size());
        for (ExecutorDetails executor : executors) {
            String compId = this.executorToComponent.get(executor);
            if (compId == null) continue;
            ret.put(executor, compId);
        }
        return ret;
    }

    public Set<ExecutorDetails> getExecutors() {
        return this.executorToComponent.keySet();
    }

    private void initResourceList() {
        Map<String, Double> topology_resources;
        this.resourceList = new HashMap<ExecutorDetails, Map<String, Double>>();
        if (this.topology.get_bolts() != null) {
            for (Map.Entry<String, Bolt> entry : this.topology.get_bolts().entrySet()) {
                topology_resources = ResourceUtils.parseResources(entry.getValue().get_common().get_json_conf());
                ResourceUtils.checkIntialization(topology_resources, entry.getValue().toString(), this.topologyConf);
                for (Map.Entry<ExecutorDetails, String> anExecutorToComponent : this.executorToComponent.entrySet()) {
                    if (!entry.getKey().equals(anExecutorToComponent.getValue())) continue;
                    this.resourceList.put(anExecutorToComponent.getKey(), topology_resources);
                }
            }
        }
        if (this.topology.get_spouts() != null) {
            for (Map.Entry<String, Comparable<Bolt>> entry : this.topology.get_spouts().entrySet()) {
                topology_resources = ResourceUtils.parseResources(((SpoutSpec)entry.getValue()).get_common().get_json_conf());
                ResourceUtils.checkIntialization(topology_resources, ((SpoutSpec)entry.getValue()).toString(), this.topologyConf);
                for (Map.Entry<ExecutorDetails, String> anExecutorToComponent : this.executorToComponent.entrySet()) {
                    if (!entry.getKey().equals(anExecutorToComponent.getValue())) continue;
                    this.resourceList.put(anExecutorToComponent.getKey(), topology_resources);
                }
            }
        } else {
            LOG.warn("Topology " + this.topologyId + " does not seem to have any spouts!");
        }
        for (ExecutorDetails executorDetails : this.getExecutors()) {
            if (this.resourceList.containsKey(executorDetails)) continue;
            LOG.debug("Scheduling {} {} with memory requirement as 'on heap' - {} and 'off heap' - {} and CPU requirement as {}", new Object[]{this.getExecutorToComponent().get(executorDetails), executorDetails, this.topologyConf.get("topology.component.resources.onheap.memory.mb"), this.topologyConf.get("topology.component.resources.offheap.memory.mb"), this.topologyConf.get("topology.component.cpu.pcore.percent")});
            this.addDefaultResforExec(executorDetails);
        }
    }

    private List<ExecutorDetails> componentToExecs(String comp) {
        ArrayList<ExecutorDetails> execs = new ArrayList<ExecutorDetails>();
        for (Map.Entry<ExecutorDetails, String> entry : this.executorToComponent.entrySet()) {
            if (!entry.getValue().equals(comp)) continue;
            execs.add(entry.getKey());
        }
        return execs;
    }

    public Map<String, Component> getComponents() {
        Component newComp;
        HashMap<String, Component> all_comp = new HashMap<String, Component>();
        StormTopology storm_topo = this.topology;
        if (storm_topo.get_spouts() != null) {
            for (Map.Entry<String, Comparable<SpoutSpec>> entry : storm_topo.get_spouts().entrySet()) {
                if (Utils.isSystemId(entry.getKey())) continue;
                if (all_comp.containsKey(entry.getKey())) {
                    newComp = (Component)all_comp.get(entry.getKey());
                    newComp.execs = this.componentToExecs(newComp.id);
                } else {
                    newComp = new Component(entry.getKey());
                    newComp.execs = this.componentToExecs(newComp.id);
                    all_comp.put(entry.getKey(), newComp);
                }
                newComp.type = Component.ComponentType.SPOUT;
                for (Map.Entry<GlobalStreamId, Grouping> spoutInput : ((SpoutSpec)entry.getValue()).get_common().get_inputs().entrySet()) {
                    newComp.parents.add(spoutInput.getKey().get_componentId());
                    if (!all_comp.containsKey(spoutInput.getKey().get_componentId())) {
                        all_comp.put(spoutInput.getKey().get_componentId(), new Component(spoutInput.getKey().get_componentId()));
                    }
                    ((Component)all_comp.get((Object)spoutInput.getKey().get_componentId())).children.add(entry.getKey());
                }
            }
        }
        if (storm_topo.get_bolts() != null) {
            for (Map.Entry<String, Comparable<SpoutSpec>> entry : storm_topo.get_bolts().entrySet()) {
                if (Utils.isSystemId(entry.getKey())) continue;
                if (all_comp.containsKey(entry.getKey())) {
                    newComp = (Component)all_comp.get(entry.getKey());
                    newComp.execs = this.componentToExecs(newComp.id);
                } else {
                    newComp = new Component(entry.getKey());
                    newComp.execs = this.componentToExecs(newComp.id);
                    all_comp.put(entry.getKey(), newComp);
                }
                newComp.type = Component.ComponentType.BOLT;
                for (Map.Entry<GlobalStreamId, Grouping> boltInput : ((Bolt)entry.getValue()).get_common().get_inputs().entrySet()) {
                    newComp.parents.add(boltInput.getKey().get_componentId());
                    if (!all_comp.containsKey(boltInput.getKey().get_componentId())) {
                        all_comp.put(boltInput.getKey().get_componentId(), new Component(boltInput.getKey().get_componentId()));
                    }
                    ((Component)all_comp.get((Object)boltInput.getKey().get_componentId())).children.add(entry.getKey());
                }
            }
        }
        return all_comp;
    }

    public Double getOnHeapMemoryRequirement(ExecutorDetails exec) {
        Double ret = null;
        if (this.hasExecInTopo(exec)) {
            ret = this.resourceList.get(exec).get("topology.component.resources.onheap.memory.mb");
        }
        return ret;
    }

    public Double getOffHeapMemoryRequirement(ExecutorDetails exec) {
        Double ret = null;
        if (this.hasExecInTopo(exec)) {
            ret = this.resourceList.get(exec).get("topology.component.resources.offheap.memory.mb");
        }
        return ret;
    }

    public Double getTotalMemReqTask(ExecutorDetails exec) {
        if (this.hasExecInTopo(exec)) {
            return this.getOffHeapMemoryRequirement(exec) + this.getOnHeapMemoryRequirement(exec);
        }
        return null;
    }

    public Map<ExecutorDetails, Double> getTotalMemoryResourceList() {
        HashMap<ExecutorDetails, Double> ret = new HashMap<ExecutorDetails, Double>();
        for (ExecutorDetails exec : this.resourceList.keySet()) {
            ret.put(exec, this.getTotalMemReqTask(exec));
        }
        return ret;
    }

    public Double getTotalCpuReqTask(ExecutorDetails exec) {
        if (this.hasExecInTopo(exec)) {
            return this.resourceList.get(exec).get("topology.component.cpu.pcore.percent");
        }
        return null;
    }

    public Double getTotalRequestedMemOnHeap() {
        Double total_memonheap = 0.0;
        for (ExecutorDetails exec : this.getExecutors()) {
            Double exec_mem = this.getOnHeapMemoryRequirement(exec);
            if (exec_mem == null) continue;
            total_memonheap = total_memonheap + exec_mem;
        }
        return total_memonheap;
    }

    public Double getTotalRequestedMemOffHeap() {
        Double total_memoffheap = 0.0;
        for (ExecutorDetails exec : this.getExecutors()) {
            Double exec_mem = this.getOffHeapMemoryRequirement(exec);
            if (exec_mem == null) continue;
            total_memoffheap = total_memoffheap + exec_mem;
        }
        return total_memoffheap;
    }

    public Double getTotalRequestedCpu() {
        Double total_cpu = 0.0;
        for (ExecutorDetails exec : this.getExecutors()) {
            Double exec_cpu = this.getTotalCpuReqTask(exec);
            if (exec_cpu == null) continue;
            total_cpu = total_cpu + exec_cpu;
        }
        return total_cpu;
    }

    public Map<String, Double> getTaskResourceReqList(ExecutorDetails exec) {
        if (this.hasExecInTopo(exec)) {
            return this.resourceList.get(exec);
        }
        return null;
    }

    public boolean hasExecInTopo(ExecutorDetails exec) {
        return this.resourceList != null && this.resourceList.containsKey(exec);
    }

    public void addResourcesForExec(ExecutorDetails exec, Map<String, Double> resourceList) {
        if (this.hasExecInTopo(exec)) {
            LOG.warn("Executor {} already exists...ResourceList: {}", (Object)exec, this.getTaskResourceReqList(exec));
            return;
        }
        this.resourceList.put(exec, resourceList);
    }

    private void addDefaultResforExec(ExecutorDetails exec) {
        Double topologyComponentCpuPcorePercent = ObjectReader.getDouble(this.topologyConf.get("topology.component.cpu.pcore.percent"), null);
        Double topologyComponentResourcesOffheapMemoryMb = ObjectReader.getDouble(this.topologyConf.get("topology.component.resources.offheap.memory.mb"), null);
        Double topologyComponentResourcesOnheapMemoryMb = ObjectReader.getDouble(this.topologyConf.get("topology.component.resources.onheap.memory.mb"), null);
        assert (topologyComponentCpuPcorePercent != null);
        assert (topologyComponentResourcesOffheapMemoryMb != null);
        assert (topologyComponentResourcesOnheapMemoryMb != null);
        HashMap<String, Double> defaultResourceList = new HashMap<String, Double>();
        defaultResourceList.put("topology.component.cpu.pcore.percent", topologyComponentCpuPcorePercent);
        defaultResourceList.put("topology.component.resources.offheap.memory.mb", topologyComponentResourcesOffheapMemoryMb);
        defaultResourceList.put("topology.component.resources.onheap.memory.mb", topologyComponentResourcesOnheapMemoryMb);
        LOG.debug("Scheduling Executor: {} with memory requirement as onHeap: {} - offHeap: {} and CPU requirement: {}", new Object[]{exec, this.topologyConf.get("topology.component.resources.onheap.memory.mb"), this.topologyConf.get("topology.component.resources.offheap.memory.mb"), this.topologyConf.get("topology.component.cpu.pcore.percent")});
        this.addResourcesForExec(exec, defaultResourceList);
    }

    private void initConfigs() {
        this.topologyWorkerMaxHeapSize = ObjectReader.getDouble(this.topologyConf.get("topology.worker.max.heap.size.mb"), null);
        this.topologyPriority = ObjectReader.getInt(this.topologyConf.get("topology.priority"), null);
        assert (this.topologyWorkerMaxHeapSize != null);
        assert (this.topologyPriority != null);
    }

    public Double getTopologyWorkerMaxHeapSize() {
        return this.topologyWorkerMaxHeapSize;
    }

    public String getTopologySubmitter() {
        String user = (String)this.topologyConf.get("topology.submitter.user");
        if (user == null || user.equals("")) {
            LOG.debug("Topology {} submitted by anonymous user", (Object)this.getName());
            user = System.getProperty("user.name");
        }
        return user;
    }

    public int getTopologyPriority() {
        return this.topologyPriority;
    }

    public int getLaunchTime() {
        return this.launchTime;
    }

    public int getUpTime() {
        return Time.currentTimeSecs() - this.launchTime;
    }

    public String toString() {
        return "Name: " + this.getName() + " id: " + this.getId() + " Priority: " + this.getTopologyPriority() + " Uptime: " + this.getUpTime() + " CPU: " + this.getTotalRequestedCpu() + " Memory: " + (this.getTotalRequestedMemOffHeap() + this.getTotalRequestedMemOnHeap());
    }

    public int hashCode() {
        return this.topologyId.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TopologyDetails)) {
            return false;
        }
        return this.topologyId.equals(((TopologyDetails)o).getId());
    }
}

