/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource;

import java.util.Collection;
import java.util.Map;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.SchedulingStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingResult {
    private Map<WorkerSlot, Collection<ExecutorDetails>> schedulingResultMap = null;
    private SchedulingStatus status = null;
    private String message = null;
    private String errorMessage = null;
    private static final Logger LOG = LoggerFactory.getLogger(SchedulingResult.class);

    private SchedulingResult(SchedulingStatus status, Map<WorkerSlot, Collection<ExecutorDetails>> schedulingResultMap, String message, String errorMessage) {
        this.status = status;
        this.schedulingResultMap = schedulingResultMap;
        this.message = message;
        this.errorMessage = errorMessage;
    }

    public static SchedulingResult failure(SchedulingStatus status, String errorMessage) {
        return new SchedulingResult(status, null, null, errorMessage);
    }

    public static SchedulingResult success(Map<WorkerSlot, Collection<ExecutorDetails>> schedulingResultMap) {
        return SchedulingResult.successWithMsg(schedulingResultMap, null);
    }

    public static SchedulingResult successWithMsg(Map<WorkerSlot, Collection<ExecutorDetails>> schedulingResultMap, String message) {
        if (schedulingResultMap == null) {
            throw new IllegalStateException("Cannot declare scheduling success without providing a non null scheduling map!");
        }
        return new SchedulingResult(SchedulingStatus.SUCCESS, schedulingResultMap, message, null);
    }

    public SchedulingStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Map<WorkerSlot, Collection<ExecutorDetails>> getSchedulingResultMap() {
        return this.schedulingResultMap;
    }

    public boolean isSuccess() {
        return SchedulingStatus.isStatusSuccess(this.status);
    }

    public boolean isFailure() {
        return SchedulingStatus.isStatusFailure(this.status);
    }

    public boolean isValid() {
        if (this.isSuccess() && this.getSchedulingResultMap() == null) {
            LOG.warn("SchedulingResult not Valid! Status is success but SchedulingResultMap is null");
            return false;
        }
        if (this.isFailure() && this.getSchedulingResultMap() != null) {
            LOG.warn("SchedulingResult not Valid! Status is Failure but SchedulingResultMap is NOT null");
            return false;
        }
        return true;
    }

    public String toString() {
        String ret = null;
        ret = this.isSuccess() ? "Status: " + (Object)((Object)this.getStatus()) + " message: " + this.getMessage() + " scheduling: " + this.getSchedulingResultMap() : "Status: " + (Object)((Object)this.getStatus()) + " error message: " + this.getErrorMessage();
        return ret;
    }
}

