/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.SaslTransportPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaslServerCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSaslServerCallbackHandler.class);
    protected final Map<String, String> credentials = new HashMap<String, String>();
    protected String userName;

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                this.handleNameCallback((NameCallback)callback);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.handlePasswordCallback((PasswordCallback)callback);
                continue;
            }
            if (callback instanceof RealmCallback) {
                this.handleRealmCallback((RealmCallback)callback);
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        }
    }

    private void handleNameCallback(NameCallback nc) {
        LOG.debug("handleNameCallback");
        this.userName = nc.getDefaultName();
        nc.setName(nc.getDefaultName());
    }

    protected void handlePasswordCallback(PasswordCallback pc) {
        LOG.debug("handlePasswordCallback");
        if (this.credentials.containsKey(this.userName)) {
            pc.setPassword(this.credentials.get(this.userName).toCharArray());
        } else {
            LOG.warn("No password found for user: {}", (Object)this.userName);
        }
    }

    private void handleRealmCallback(RealmCallback rc) {
        LOG.debug("handleRealmCallback: {}", (Object)rc.getDefaultText());
        rc.setText(rc.getDefaultText());
    }

    private void handleAuthorizeCallback(AuthorizeCallback ac) {
        String authenticationID = ac.getAuthenticationID();
        LOG.info("Successfully authenticated client: authenticationID = {} authorizationID = {}", (Object)authenticationID, (Object)ac.getAuthorizationID());
        if (ac.getAuthorizationID() == null) {
            ac.setAuthorizedID(authenticationID);
        }
        if (!authenticationID.equals(ac.getAuthorizationID())) {
            LOG.info("Impersonation attempt  authenticationID = {} authorizationID = {}", (Object)ac.getAuthenticationID(), (Object)ac.getAuthorizationID());
            ReqContext.context().setRealPrincipal(new SaslTransportPlugin.User(ac.getAuthenticationID()));
        } else {
            ReqContext.context().setRealPrincipal(null);
        }
        ac.setAuthorized(true);
    }
}

