/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.bind.DatatypeConverter;
import org.apache.storm.security.auth.IAutoCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSSL
implements IAutoCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(AutoSSL.class);
    private Map<String, Object> conf;
    private String writeDir = "./";
    public static final String SSL_FILES_CONF = "ssl.credential.files";

    @Override
    public void prepare(Map<String, Object> conf) {
        this.conf = conf;
        this.writeDir = this.getSSLWriteDirFromConf(this.conf);
    }

    @VisibleForTesting
    protected String getSSLWriteDirFromConf(Map<String, Object> conf) {
        return "./";
    }

    @VisibleForTesting
    Collection<String> getSSLFilesFromConf(Map<String, Object> conf) {
        Object sslConf = conf.get(SSL_FILES_CONF);
        if (sslConf == null) {
            LOG.info("No ssl files requested, if you want to use SSL please set {} to the list of files", (Object)SSL_FILES_CONF);
            return null;
        }
        List<String> sslFiles = null;
        if (sslConf instanceof Collection) {
            sslFiles = (List<String>)sslConf;
        } else if (sslConf instanceof String) {
            sslFiles = Arrays.asList(((String)sslConf).split(","));
        } else {
            throw new RuntimeException("ssl.credential.files is not set to something that I know how to use " + sslConf);
        }
        return sslFiles;
    }

    @Override
    public void populateCredentials(Map<String, String> credentials) {
        try {
            Collection<String> sslFiles = this.getSSLFilesFromConf(this.conf);
            if (sslFiles == null) {
                return;
            }
            LOG.info("AutoSSL files: {}", sslFiles);
            for (String inputFile : sslFiles) {
                AutoSSL.serializeSSLFile(inputFile, credentials);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void serializeSSLFile(String readFile, Map<String, String> credentials) {
        try {
            int length;
            FileInputStream in = new FileInputStream(readFile);
            LOG.debug("serializing ssl file: {}", (Object)readFile);
            ByteArrayOutputStream result2 = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) != -1) {
                result2.write(buffer, 0, length);
            }
            String resultStr = DatatypeConverter.printBase64Binary((byte[])result2.toByteArray());
            File f = new File(readFile);
            LOG.debug("ssl read files is name: {}", (Object)f.getName());
            credentials.put(f.getName(), resultStr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void deserializeSSLFile(String credsKey, String directory, Map<String, String> credentials) {
        try {
            LOG.debug("deserializing ssl file with key: {}", (Object)credsKey);
            String resultStr = null;
            if (credentials != null && credentials.containsKey(credsKey) && credentials.get(credsKey) != null) {
                resultStr = credentials.get(credsKey);
            }
            if (resultStr != null) {
                byte[] decodedData = DatatypeConverter.parseBase64Binary(resultStr);
                File f = new File(directory, credsKey);
                FileOutputStream fout = new FileOutputStream(f);
                fout.write(decodedData);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateSubject(Subject subject, Map<String, String> credentials) {
        this.populateSubject(subject, credentials);
    }

    @Override
    public void populateSubject(Subject subject, Map<String, String> credentials) {
        LOG.info("AutoSSL populating credentials");
        Collection<String> sslFiles = this.getSSLFilesFromConf(this.conf);
        if (sslFiles == null) {
            LOG.debug("ssl files is null");
            return;
        }
        for (String outputFile : sslFiles) {
            AutoSSL.deserializeSSLFile(new File(outputFile).getName(), this.writeDir, credentials);
        }
    }
}

