/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.SingleUserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpCredentialsPlugin
implements IHttpCredentialsPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpCredentialsPlugin.class);

    @Override
    public void prepare(Map<String, Object> topoConf) {
    }

    @Override
    public String getUserName(HttpServletRequest req) {
        String userName;
        Principal princ;
        if (req != null && (princ = req.getUserPrincipal()) != null && (userName = princ.getName()) != null && !userName.isEmpty()) {
            LOG.debug("HTTP request had user (" + userName + ")");
            return userName;
        }
        return null;
    }

    @Override
    public ReqContext populateContext(ReqContext context, HttpServletRequest req) {
        String userName = this.getUserName(req);
        String doAsUser = req.getHeader("doAsUser");
        if (doAsUser == null) {
            doAsUser = req.getParameter("doAsUser");
        }
        if (doAsUser != null) {
            context.setRealPrincipal(new SingleUserPrincipal(userName));
            userName = doAsUser;
        } else {
            context.setRealPrincipal(null);
        }
        HashSet<SingleUserPrincipal> principals = new HashSet<SingleUserPrincipal>();
        if (userName != null) {
            SingleUserPrincipal p = new SingleUserPrincipal(userName);
            principals.add(p);
        }
        Subject s = new Subject(true, principals, new HashSet(), new HashSet());
        context.setSubject(s);
        return context;
    }
}

