/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.util.Map;
import org.apache.storm.utils.ObjectReader;

public enum ThriftConnectionType {
    NIMBUS("nimbus.thrift.transport", "nimbus.thrift.port", "nimbus.queue.size", "nimbus.thrift.threads", "nimbus.thrift.max_buffer_size", "storm.thrift.socket.timeout.ms"),
    DRPC("drpc.thrift.transport", "drpc.port", "drpc.queue.size", "drpc.worker.threads", "drpc.max_buffer_size", null),
    DRPC_INVOCATIONS("drpc.invocations.thrift.transport", "drpc.invocations.port", null, "drpc.invocations.threads", "drpc.max_buffer_size", null),
    LOCAL_FAKE;

    private final String _transConf;
    private final String _portConf;
    private final String _qConf;
    private final String _threadsConf;
    private final String _buffConf;
    private final String _socketTimeoutConf;
    private final boolean _isFake;

    private ThriftConnectionType() {
        this(null, null, null, null, null, null, true);
    }

    private ThriftConnectionType(String transConf, String portConf, String qConf, String threadsConf, String buffConf, String socketTimeoutConf) {
        this(transConf, portConf, qConf, threadsConf, buffConf, socketTimeoutConf, false);
    }

    private ThriftConnectionType(String transConf, String portConf, String qConf, String threadsConf, String buffConf, String socketTimeoutConf, boolean isFake) {
        this._transConf = transConf;
        this._portConf = portConf;
        this._qConf = qConf;
        this._threadsConf = threadsConf;
        this._buffConf = buffConf;
        this._socketTimeoutConf = socketTimeoutConf;
        this._isFake = isFake;
    }

    public boolean isFake() {
        return this._isFake;
    }

    public String getTransportPlugin(Map<String, Object> conf) {
        String ret = (String)conf.get(this._transConf);
        if (ret == null) {
            ret = (String)conf.get("storm.thrift.transport");
        }
        return ret;
    }

    public int getPort(Map<String, Object> conf) {
        if (this._isFake) {
            return -1;
        }
        return ObjectReader.getInt(conf.get(this._portConf));
    }

    public Integer getQueueSize(Map<String, Object> conf) {
        if (this._qConf == null) {
            return null;
        }
        return (Integer)conf.get(this._qConf);
    }

    public int getNumThreads(Map<String, Object> conf) {
        if (this._isFake) {
            return 1;
        }
        return ObjectReader.getInt(conf.get(this._threadsConf));
    }

    public int getMaxBufferSize(Map<String, Object> conf) {
        if (this._isFake) {
            return 1;
        }
        return ObjectReader.getInt(conf.get(this._buffConf));
    }

    public Integer getSocketTimeOut(Map<String, Object> conf) {
        if (this._socketTimeoutConf == null) {
            return null;
        }
        return ObjectReader.getInt(conf.get(this._socketTimeoutConf));
    }
}

