/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.apache.storm.security.auth.AuthUtils;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServer {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftServer.class);
    private Map _topoConf;
    protected TProcessor _processor = null;
    private final ThriftConnectionType _type;
    private TServer _server;
    private Configuration _login_conf;
    private int _port;

    public ThriftServer(Map<String, Object> topoConf, TProcessor processor, ThriftConnectionType type) {
        this._topoConf = topoConf;
        this._processor = processor;
        this._type = type;
        try {
            this._login_conf = AuthUtils.GetConfiguration(this._topoConf);
        }
        catch (Exception x) {
            LOG.error(x.getMessage(), (Throwable)x);
        }
        try {
            ITransportPlugin transportPlugin = AuthUtils.GetTransportPlugin(this._type, this._topoConf, this._login_conf);
            this._server = transportPlugin.getServer(this._processor);
            this._port = transportPlugin.getPort();
        }
        catch (IOException | TTransportException ex) {
            this.handleServerException((Exception)ex);
        }
    }

    public void stop() {
        this._server.stop();
    }

    public boolean isServing() {
        return this._server.isServing();
    }

    public void serve() {
        try {
            this._server.serve();
        }
        catch (Exception ex) {
            this.handleServerException(ex);
        }
    }

    private void handleServerException(Exception ex) {
        LOG.error("ThriftServer is being stopped due to: " + ex, (Throwable)ex);
        if (this._server != null) {
            this._server.stop();
        }
        Runtime.getRuntime().halt(1);
    }

    public int getPort() {
        return this._port;
    }
}

