/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.digest;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.storm.security.auth.AbstractSaslServerCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCallbackHandler
extends AbstractSaslServerCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServerCallbackHandler.class);
    private static final String USER_PREFIX = "user_";
    public static final String SYSPROP_SUPER_PASSWORD = "storm.SASLAuthenticationProvider.superPassword";

    public ServerCallbackHandler(Configuration configuration) throws IOException {
        if (configuration == null) {
            return;
        }
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry("StormServer");
        if (configurationEntries == null) {
            String errorMessage = "Could not find a 'StormServer' entry in this configuration: Server cannot start.";
            throw new IOException(errorMessage);
        }
        this.credentials.clear();
        for (AppConfigurationEntry entry : configurationEntries) {
            Map<String, ?> options = entry.getOptions();
            for (Map.Entry<String, ?> pair : options.entrySet()) {
                String key = pair.getKey();
                if (!key.startsWith(USER_PREFIX)) continue;
                String userName = key.substring(USER_PREFIX.length());
                this.credentials.put(userName, (String)pair.getValue());
            }
        }
    }

    @Override
    protected void handlePasswordCallback(PasswordCallback pc) {
        LOG.debug("handlePasswordCallback");
        if ("super".equals(this.userName) && System.getProperty(SYSPROP_SUPER_PASSWORD) != null) {
            pc.setPassword(System.getProperty(SYSPROP_SUPER_PASSWORD).toCharArray());
        } else {
            super.handlePasswordCallback(pc);
        }
    }
}

