/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.plain;

import java.io.IOException;
import java.security.Security;
import javax.security.auth.callback.CallbackHandler;
import org.apache.storm.security.auth.SaslTransportPlugin;
import org.apache.storm.security.auth.plain.PlainClientCallbackHandler;
import org.apache.storm.security.auth.plain.PlainServerCallbackHandler;
import org.apache.storm.security.auth.plain.SaslPlainServer;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainSaslTransportPlugin
extends SaslTransportPlugin {
    public static final String PLAIN = "PLAIN";
    private static final Logger LOG = LoggerFactory.getLogger(PlainSaslTransportPlugin.class);

    @Override
    protected TTransportFactory getServerTransportFactory() throws IOException {
        PlainServerCallbackHandler serverCallbackHandler = new PlainServerCallbackHandler();
        if (Security.getProvider("SaslPlainServer") == null) {
            Security.addProvider(new SaslPlainServer.SecurityProvider());
        }
        TSaslServerTransport.Factory factory = new TSaslServerTransport.Factory();
        factory.addServerDefinition(PLAIN, "storm_thrift_server", "localhost", null, (CallbackHandler)serverCallbackHandler);
        LOG.info("SASL PLAIN transport factory will be used");
        return factory;
    }

    @Override
    public TTransport connect(TTransport transport, String serverHost, String asUser) throws IOException, TTransportException {
        PlainClientCallbackHandler clientCallbackHandler = new PlainClientCallbackHandler();
        TSaslClientTransport wrapperTransport = new TSaslClientTransport(PLAIN, null, "storm_thrift_server", serverHost, null, (CallbackHandler)clientCallbackHandler, transport);
        wrapperTransport.open();
        LOG.debug("SASL PLAIN client transport has been established");
        return wrapperTransport;
    }
}

