/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.state;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Collections;
import java.util.List;
import org.apache.storm.state.Serializer;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class DefaultStateSerializer<T>
implements Serializer<T> {
    private final ThreadLocal<Kryo> kryo = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            Kryo obj = new Kryo();
            obj.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            return obj;
        }
    };
    private final ThreadLocal<Output> output = new ThreadLocal<Output>(){

        @Override
        protected Output initialValue() {
            return new Output(2000, 2000000000);
        }
    };

    public DefaultStateSerializer(List<Class<?>> classesToRegister) {
        for (Class<?> klazz : classesToRegister) {
            this.kryo.get().register(klazz);
        }
    }

    public DefaultStateSerializer() {
        this(Collections.emptyList());
    }

    @Override
    public byte[] serialize(T obj) {
        this.output.get().clear();
        this.kryo.get().writeClassAndObject(this.output.get(), obj);
        return this.output.get().toBytes();
    }

    @Override
    public T deserialize(byte[] b) {
        Input input = new Input(b);
        return (T)this.kryo.get().readClassAndObject(input);
    }
}

