/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import com.google.common.collect.Multimap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.storm.streams.Edge;
import org.apache.storm.streams.Node;
import org.apache.storm.streams.Pair;
import org.apache.storm.streams.ProcessorBoltDelegate;
import org.apache.storm.streams.ProcessorNode;
import org.apache.storm.streams.StreamBolt;
import org.apache.storm.streams.StreamUtil;
import org.apache.storm.streams.windowing.SlidingWindows;
import org.apache.storm.streams.windowing.TumblingWindows;
import org.apache.storm.streams.windowing.Window;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseWindowedBolt;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.windowing.TupleWindow;
import org.jgrapht.DirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowedProcessorBolt
extends BaseWindowedBolt
implements StreamBolt {
    private static final Logger LOG = LoggerFactory.getLogger(WindowedProcessorBolt.class);
    private final ProcessorBoltDelegate delegate;
    private final Window<?, ?> window;

    WindowedProcessorBolt(String id, DirectedGraph<Node, Edge> graph, List<ProcessorNode> nodes, Window<?, ?> window) {
        this.delegate = new ProcessorBoltDelegate(id, graph, nodes);
        this.window = window;
        this.setWindowConfig();
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this.delegate.prepare(topoConf, context, collector);
    }

    @Override
    public void execute(TupleWindow inputWindow) {
        LOG.trace("Window triggered at {}, inputWindow {}", (Object)new Date(), (Object)inputWindow);
        if (this.delegate.isEventTimestamp()) {
            this.delegate.setEventTimestamp(inputWindow.getEndTimestamp());
        }
        for (Tuple tuple : inputWindow.get()) {
            Pair<Object, String> valueAndStream = this.delegate.getValueAndStream(tuple);
            if (StreamUtil.isPunctuation(valueAndStream.getFirst())) continue;
            this.delegate.process(valueAndStream.getFirst(), valueAndStream.getSecond());
        }
        for (String stream : this.delegate.getInitialStreams()) {
            this.delegate.process("__punctuation", stream);
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.delegate.declareOutputFields(declarer);
    }

    @Override
    public void setTimestampField(String fieldName) {
        this.delegate.setTimestampField(fieldName);
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    private void setWindowConfig() {
        if (this.window instanceof SlidingWindows) {
            this.setSlidingWindowParams(this.window.getWindowLength(), this.window.getSlidingInterval());
        } else if (this.window instanceof TumblingWindows) {
            this.setTumblingWindowParams(this.window.getWindowLength());
        }
        if (this.window.getTimestampField() != null) {
            this.withTimestampField(this.window.getTimestampField());
        }
        if (this.window.getLag() != null) {
            this.withLag(this.window.getLag());
        }
        if (this.window.getLateTupleStream() != null) {
            this.withLateTupleStream(this.window.getLateTupleStream());
        }
    }

    private void setSlidingWindowParams(Object windowLength, Object slidingInterval) {
        if (windowLength instanceof BaseWindowedBolt.Count) {
            if (slidingInterval instanceof BaseWindowedBolt.Count) {
                this.withWindow((BaseWindowedBolt.Count)windowLength, (BaseWindowedBolt.Count)slidingInterval);
            } else if (slidingInterval instanceof BaseWindowedBolt.Duration) {
                this.withWindow((BaseWindowedBolt.Count)windowLength, (BaseWindowedBolt.Duration)slidingInterval);
            }
        } else if (windowLength instanceof BaseWindowedBolt.Duration) {
            if (slidingInterval instanceof BaseWindowedBolt.Count) {
                this.withWindow((BaseWindowedBolt.Duration)windowLength, (BaseWindowedBolt.Count)slidingInterval);
            } else if (slidingInterval instanceof BaseWindowedBolt.Duration) {
                this.withWindow((BaseWindowedBolt.Duration)windowLength, (BaseWindowedBolt.Duration)slidingInterval);
            }
        }
    }

    private void setTumblingWindowParams(Object windowLength) {
        if (windowLength instanceof BaseWindowedBolt.Count) {
            this.withTumblingWindow((BaseWindowedBolt.Count)windowLength);
        } else if (windowLength instanceof BaseWindowedBolt.Duration) {
            this.withTumblingWindow((BaseWindowedBolt.Duration)windowLength);
        }
    }

    void setStreamToInitialProcessors(Multimap<String, ProcessorNode> streamToInitialProcessors) {
        this.delegate.setStreamToInitialProcessors(streamToInitialProcessors);
    }
}

