/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.operations;

import org.apache.storm.streams.operations.BiFunction;
import org.apache.storm.streams.operations.Operation;

public interface CombinerAggregator<T, A, R>
extends Operation {
    public A init();

    public A apply(A var1, T var2);

    public A merge(A var1, A var2);

    public R result(A var1);

    public static <T, R> CombinerAggregator<T, R, R> of(final R initialValue, final BiFunction<? super R, ? super T, ? extends R> accumulator, final BiFunction<? super R, ? super R, ? extends R> combiner) {
        return new CombinerAggregator<T, R, R>(){

            @Override
            public R init() {
                return initialValue;
            }

            @Override
            public R apply(R aggregate, T value) {
                return accumulator.apply(aggregate, value);
            }

            @Override
            public R merge(R accum1, R accum2) {
                return combiner.apply(accum1, accum2);
            }

            @Override
            public R result(R accum) {
                return accum;
            }
        };
    }
}

