/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.storm.coordination.BatchOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseBatchBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class BatchNumberList
extends BaseBatchBolt<Object> {
    String _wordComponent;
    String word = null;
    List<Integer> intSet = new ArrayList<Integer>();
    BatchOutputCollector _collector;

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("word", "list"));
    }

    public BatchNumberList(String wordComponent) {
        this._wordComponent = wordComponent;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, BatchOutputCollector collector, Object id) {
        this._collector = collector;
    }

    @Override
    public void execute(Tuple tuple) {
        if (tuple.getSourceComponent().equals(this._wordComponent)) {
            this.word = tuple.getString(1);
        } else {
            this.intSet.add(tuple.getInteger(1));
        }
    }

    @Override
    public void finishBatch() {
        if (this.word != null) {
            Collections.sort(this.intSet);
            this._collector.emit(new Values(this.word, this.intSet));
        }
    }
}

