/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.coordination.BatchOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseBatchBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.Utils;

public class KeyedCountingBatchBolt
extends BaseBatchBolt<Object> {
    BatchOutputCollector _collector;
    Object _id;
    Map<Object, Integer> _counts = new HashMap<Object, Integer>();

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, BatchOutputCollector collector, Object id) {
        this._collector = collector;
        this._id = id;
    }

    @Override
    public void execute(Tuple tuple) {
        Object key = tuple.getValue(1);
        int curr = Utils.get(this._counts, key, 0);
        this._counts.put(key, curr + 1);
    }

    @Override
    public void finishBatch() {
        for (Object key : this._counts.keySet()) {
            this._collector.emit(new Values(this._id, key, this._counts.get(key)));
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("tx", "key", "count"));
    }
}

