/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEventOrderCheckBolt
extends BaseRichBolt {
    public static Logger LOG = LoggerFactory.getLogger(TestEventOrderCheckBolt.class);
    private int _count;
    OutputCollector _collector;
    Map<Integer, Long> recentEventId = new HashMap<Integer, Long>();

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this._collector = collector;
        this._count = 0;
    }

    @Override
    public void execute(Tuple input) {
        Integer sourceId = input.getInteger(0);
        Long eventId = input.getLong(1);
        Long recentEvent = this.recentEventId.get(sourceId);
        if (null != recentEvent && eventId <= recentEvent) {
            String error = "Error: event id is not in strict order! event source Id: " + sourceId + ", last event Id: " + recentEvent + ", current event Id: " + eventId;
            this._collector.emit(input, (List<Object>)new Values(error));
        }
        this.recentEventId.put(sourceId, eventId);
        this._collector.ack(input);
    }

    @Override
    public void cleanup() {
    }

    public Fields getOutputFields() {
        return new Fields("error");
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("error"));
    }
}

