/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.topology.ResourceDeclarer;
import org.apache.storm.trident.operation.ITridentResource;
import org.apache.storm.utils.Utils;

public class DefaultResourceDeclarer<T extends DefaultResourceDeclarer>
implements ResourceDeclarer<T>,
ITridentResource {
    private Map<String, Number> resources = new HashMap<String, Number>();
    private static Map<String, Object> conf = Utils.readStormConfig();

    @Override
    public T setMemoryLoad(Number onHeap) {
        if (onHeap != null) {
            onHeap = onHeap.doubleValue();
            this.resources.put("topology.component.resources.onheap.memory.mb", onHeap);
        }
        return (T)this;
    }

    @Override
    public T setMemoryLoad(Number onHeap, Number offHeap) {
        this.setMemoryLoad(onHeap);
        if (offHeap != null) {
            offHeap = offHeap.doubleValue();
            this.resources.put("topology.component.resources.offheap.memory.mb", offHeap);
        }
        return (T)this;
    }

    @Override
    public T setCPULoad(Number amount) {
        if (amount != null) {
            amount = amount.doubleValue();
            this.resources.put("topology.component.cpu.pcore.percent", amount);
        }
        return (T)this;
    }

    @Override
    public Map<String, Number> getResources() {
        return new HashMap<String, Number>(this.resources);
    }
}

