/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation.impl;

import java.util.List;
import java.util.Map;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.operation.impl.CaptureCollector;
import org.apache.storm.trident.operation.impl.ChainedResult;
import org.apache.storm.trident.tuple.ComboList;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class ChainedAggregatorImpl
implements Aggregator<ChainedResult> {
    Aggregator[] _aggs;
    TridentTupleView.ProjectionFactory[] _inputFactories;
    ComboList.Factory _fact;
    Fields[] _inputFields;

    public ChainedAggregatorImpl(Aggregator[] aggs, Fields[] inputFields, ComboList.Factory fact) {
        this._aggs = aggs;
        this._inputFields = inputFields;
        this._fact = fact;
        if (this._aggs.length != this._inputFields.length) {
            throw new IllegalArgumentException("Require input fields for each aggregator");
        }
    }

    @Override
    public void prepare(Map<String, Object> conf, TridentOperationContext context) {
        this._inputFactories = new TridentTupleView.ProjectionFactory[this._inputFields.length];
        for (int i = 0; i < this._inputFields.length; ++i) {
            this._inputFactories[i] = context.makeProjectionFactory(this._inputFields[i]);
            this._aggs[i].prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this._inputFactories[i]));
        }
    }

    @Override
    public ChainedResult init(Object batchId, TridentCollector collector) {
        ChainedResult initted = new ChainedResult(collector, this._aggs.length);
        for (int i = 0; i < this._aggs.length; ++i) {
            initted.objs[i] = this._aggs[i].init(batchId, initted.collectors[i]);
        }
        return initted;
    }

    @Override
    public void aggregate(ChainedResult val, TridentTuple tuple, TridentCollector collector) {
        val.setFollowThroughCollector(collector);
        for (int i = 0; i < this._aggs.length; ++i) {
            TridentTuple projected = this._inputFactories[i].create((TridentTupleView)tuple);
            this._aggs[i].aggregate(val.objs[i], projected, val.collectors[i]);
        }
    }

    @Override
    public void complete(ChainedResult val, TridentCollector collector) {
        val.setFollowThroughCollector(collector);
        for (int i = 0; i < this._aggs.length; ++i) {
            this._aggs[i].complete(val.objs[i], val.collectors[i]);
        }
        if (this._aggs.length > 1) {
            int[] indices = new int[val.collectors.length];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = 0;
            }
            boolean keepGoing = true;
            while (keepGoing) {
                List[] combined = new List[this._aggs.length];
                for (int i = 0; i < this._aggs.length; ++i) {
                    CaptureCollector capturer = (CaptureCollector)val.collectors[i];
                    combined[i] = capturer.captured.get(indices[i]);
                }
                collector.emit(this._fact.create(combined));
                keepGoing = this.increment(val.collectors, indices, indices.length - 1);
            }
        }
    }

    private boolean increment(TridentCollector[] lengths, int[] indices, int j) {
        if (j == -1) {
            return false;
        }
        int n = j;
        indices[n] = indices[n] + 1;
        CaptureCollector capturer = (CaptureCollector)lengths[j];
        if (indices[j] >= capturer.captured.size()) {
            indices[j] = 0;
            return this.increment(lengths, indices, j - 1);
        }
        return true;
    }

    @Override
    public void cleanup() {
        for (Aggregator a : this._aggs) {
            a.cleanup();
        }
    }
}

