/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.trident.JoinType;
import org.apache.storm.trident.operation.GroupedMultiReducer;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentMultiReducerContext;
import org.apache.storm.trident.operation.impl.JoinState;
import org.apache.storm.trident.tuple.ComboList;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.Fields;

public class PreservingFieldsOrderJoinerMultiReducer
implements GroupedMultiReducer<JoinState> {
    List<JoinType> _types;
    List<Fields> _sideFields;
    List<Fields> _joiningFields;
    List<Fields> _originFields;
    int _numGroupFields;
    ComboList.Factory _factory;

    public PreservingFieldsOrderJoinerMultiReducer(List<JoinType> types, int numGroupFields, List<Fields> origins, List<Fields> joins, List<Fields> sides) {
        this._types = types;
        this._originFields = origins;
        this._joiningFields = joins;
        this._sideFields = sides;
        this._numGroupFields = numGroupFields;
    }

    @Override
    public void prepare(Map<String, Object> conf, TridentMultiReducerContext context) {
        int[] sizes = new int[this._originFields.size()];
        for (int i = 0; i < this._originFields.size(); ++i) {
            sizes[i] = this._originFields.get(i).size();
        }
        this._factory = new ComboList.Factory(sizes);
    }

    @Override
    public JoinState init(TridentCollector collector, TridentTuple group) {
        return new JoinState(this._types.size(), group);
    }

    @Override
    public void execute(JoinState state, int streamIndex, TridentTuple group, TridentTuple input, TridentCollector collector) {
        List<List> side = state.sides[streamIndex];
        if (side.isEmpty()) {
            ++state.numSidesReceived;
        }
        side.add(input);
        if (state.numSidesReceived == state.sides.length) {
            this.emitCrossJoin(state, collector, streamIndex, input);
        }
    }

    @Override
    public void complete(JoinState state, TridentTuple group, TridentCollector collector) {
        List<List>[] sides = state.sides;
        boolean wasEmpty = state.numSidesReceived < sides.length;
        for (int i = 0; i < sides.length; ++i) {
            if (!sides[i].isEmpty() || this._types.get(i) != JoinType.OUTER) continue;
            ++state.numSidesReceived;
            sides[i].add(null);
        }
        if (wasEmpty && state.numSidesReceived == sides.length) {
            this.emitCrossJoin(state, collector, -1, null);
        }
    }

    @Override
    public void cleanup() {
    }

    private List<Object> makeNullList(int size) {
        ArrayList<Object> ret = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(null);
        }
        return ret;
    }

    private void emitCrossJoin(JoinState state, TridentCollector collector, int overrideIndex, TridentTuple overrideTuple) {
        List[] sides = state.sides;
        int[] indices = state.indices;
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = 0;
        }
        boolean keepGoing = true;
        while (keepGoing) {
            List[] combined = new List[sides.length];
            for (int i = 0; i < sides.length; ++i) {
                List<Object> values;
                combined[i] = values = this.buildValuesForStream(state, overrideIndex, overrideTuple, sides, indices, combined, i);
            }
            collector.emit(this._factory.create(combined));
            keepGoing = this.increment(sides, indices, indices.length - 1, overrideIndex);
        }
    }

    private List<Object> buildValuesForStream(JoinState state, int overrideIndex, TridentTuple overrideTuple, List<List>[] sides, int[] indices, List[] combined, int streamIdx) {
        List<Object> sideValues = streamIdx == overrideIndex ? overrideTuple : sides[streamIdx].get(indices[streamIdx]);
        Fields originFields = this._originFields.get(streamIdx);
        if (sideValues == null) {
            return this.makeNullList(originFields.size());
        }
        ArrayList<Object> ret = new ArrayList<Object>(originFields.size());
        Fields sideFields = this._sideFields.get(streamIdx);
        Fields joinFields = this._joiningFields.get(streamIdx);
        int sideIdx = 0;
        for (String field : originFields) {
            if (sideFields.contains(field)) {
                ret.add(sideValues.get(sideIdx++));
                continue;
            }
            ret.add(state.group.get(joinFields.fieldIndex(field)));
        }
        return ret;
    }

    private boolean increment(List[] lengths, int[] indices, int j, int overrideIndex) {
        if (j == -1) {
            return false;
        }
        if (j == overrideIndex) {
            return this.increment(lengths, indices, j - 1, overrideIndex);
        }
        int n = j;
        indices[n] = indices[n] + 1;
        if (indices[j] >= lengths[j].size()) {
            indices[j] = 0;
            return this.increment(lengths, indices, j - 1, overrideIndex);
        }
        return true;
    }
}

