/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.spout;

import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BasicOutputCollector;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.topology.state.RotatingTransactionalState;
import org.apache.storm.trident.topology.state.TransactionalState;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TridentSpoutCoordinator
implements IBasicBolt {
    public static final Logger LOG = LoggerFactory.getLogger(TridentSpoutCoordinator.class);
    private static final String META_DIR = "meta";
    ITridentSpout<Object> _spout;
    ITridentSpout.BatchCoordinator<Object> _coord;
    RotatingTransactionalState _state;
    TransactionalState _underlyingState;
    String _id;

    public TridentSpoutCoordinator(String id, ITridentSpout<Object> spout) {
        this._spout = spout;
        this._id = id;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context) {
        this._coord = this._spout.getCoordinator(this._id, conf, context);
        this._underlyingState = TransactionalState.newCoordinatorState(conf, this._id);
        this._state = new RotatingTransactionalState(this._underlyingState, META_DIR);
    }

    @Override
    public void execute(Tuple tuple, BasicOutputCollector collector) {
        TransactionAttempt attempt = (TransactionAttempt)tuple.getValue(0);
        if (tuple.getSourceStreamId().equals("$success")) {
            this._state.cleanupBefore(attempt.getTransactionId());
            this._coord.success(attempt.getTransactionId());
        } else {
            long txid = attempt.getTransactionId();
            Object prevMeta = this._state.getPreviousState(txid);
            Object meta = this._coord.initializeTransaction(txid, prevMeta, this._state.getState(txid));
            this._state.overrideState(txid, meta);
            collector.emit("$batch", new Values(attempt, meta));
        }
    }

    @Override
    public void cleanup() {
        this._coord.close();
        this._underlyingState.close();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declareStream("$batch", new Fields("tx", "metadata"));
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        Config ret = new Config();
        ret.setMaxTaskParallelism(1);
        return ret;
    }
}

