/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.state.map;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.state.CombinerValueUpdater;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.state.ValueUpdater;
import org.apache.storm.trident.state.map.MapState;
import org.apache.storm.trident.tuple.ComboList;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class MapCombinerAggStateUpdater
implements StateUpdater<MapState> {
    private static final long serialVersionUID = -3960578785572592092L;
    CombinerAggregator _agg;
    Fields _groupFields;
    Fields _inputFields;
    transient TridentTupleView.ProjectionFactory _groupFactory;
    transient TridentTupleView.ProjectionFactory _inputFactory;
    ComboList.Factory _factory;

    public MapCombinerAggStateUpdater(CombinerAggregator agg, Fields groupFields, Fields inputFields) {
        this._agg = agg;
        this._groupFields = groupFields;
        this._inputFields = inputFields;
        if (inputFields.size() != 1) {
            throw new IllegalArgumentException("Combiner aggs only take a single field as input. Got this instead: " + inputFields.toString());
        }
        this._factory = new ComboList.Factory(groupFields.size(), inputFields.size());
    }

    @Override
    public void updateState(MapState map, List<TridentTuple> tuples, TridentCollector collector) {
        ArrayList<List<Object>> groups = new ArrayList<List<Object>>(tuples.size());
        ArrayList<ValueUpdater> updaters = new ArrayList<ValueUpdater>(tuples.size());
        for (TridentTuple t : tuples) {
            groups.add(this._groupFactory.create(t));
            updaters.add(new CombinerValueUpdater(this._agg, this._inputFactory.create(t).getValue(0)));
        }
        List newVals = map.multiUpdate(groups, updaters);
        for (int i = 0; i < tuples.size(); ++i) {
            List key = (List)groups.get(i);
            Object result2 = newVals.get(i);
            collector.emit(this._factory.create(new List[]{key, new Values(result2)}));
        }
    }

    @Override
    public void prepare(Map<String, Object> conf, TridentOperationContext context) {
        this._groupFactory = context.makeProjectionFactory(this._groupFields);
        this._inputFactory = context.makeProjectionFactory(this._inputFields);
    }

    @Override
    public void cleanup() {
    }
}

