/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.state.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.storm.trident.state.map.IBackingMap;

public class MicroBatchIBackingMap<T>
implements IBackingMap<T> {
    IBackingMap<T> _delegate;
    Options _options;

    public MicroBatchIBackingMap(Options options, IBackingMap<T> delegate) {
        this._options = options;
        this._delegate = delegate;
        assert (options.maxMultiPutBatchSize >= 0);
        assert (options.maxMultiGetBatchSize >= 0);
    }

    @Override
    public void multiPut(List<List<Object>> keys, List<T> values) {
        int thisBatchSize = this._options.maxMultiPutBatchSize == 0 ? keys.size() : this._options.maxMultiPutBatchSize;
        LinkedList<List<Object>> keysTodo = new LinkedList<List<Object>>(keys);
        LinkedList<T> valuesTodo = new LinkedList<T>(values);
        while (!keysTodo.isEmpty()) {
            ArrayList<List<Object>> keysBatch = new ArrayList<List<Object>>(thisBatchSize);
            ArrayList<T> valuesBatch = new ArrayList<T>(thisBatchSize);
            for (int i = 0; i < thisBatchSize && !keysTodo.isEmpty(); ++i) {
                keysBatch.add(keysTodo.removeFirst());
                valuesBatch.add(valuesTodo.removeFirst());
            }
            this._delegate.multiPut(keysBatch, valuesBatch);
        }
    }

    @Override
    public List<T> multiGet(List<List<Object>> keys) {
        int thisBatchSize = this._options.maxMultiGetBatchSize == 0 ? keys.size() : this._options.maxMultiGetBatchSize;
        LinkedList<List<Object>> keysTodo = new LinkedList<List<Object>>(keys);
        ArrayList<T> ret = new ArrayList<T>(keys.size());
        while (!keysTodo.isEmpty()) {
            ArrayList<List<Object>> keysBatch = new ArrayList<List<Object>>(thisBatchSize);
            for (int i = 0; i < thisBatchSize && !keysTodo.isEmpty(); ++i) {
                keysBatch.add(keysTodo.removeFirst());
            }
            List<T> retSubset = this._delegate.multiGet(keysBatch);
            ret.addAll(retSubset);
        }
        return ret;
    }

    public static class Options
    implements Serializable {
        public int maxMultiGetBatchSize = 0;
        public int maxMultiPutBatchSize = 0;
    }
}

