/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.state.map;

import java.util.ArrayList;
import java.util.List;
import org.apache.storm.trident.state.TransactionalValue;
import org.apache.storm.trident.state.ValueUpdater;
import org.apache.storm.trident.state.map.CachedBatchReadsMap;
import org.apache.storm.trident.state.map.IBackingMap;
import org.apache.storm.trident.state.map.MapState;

public class TransactionalMap<T>
implements MapState<T> {
    CachedBatchReadsMap<TransactionalValue> _backing;
    Long _currTx;

    public static <T> MapState<T> build(IBackingMap<TransactionalValue> backing) {
        return new TransactionalMap<T>(backing);
    }

    protected TransactionalMap(IBackingMap<TransactionalValue> backing) {
        this._backing = new CachedBatchReadsMap<TransactionalValue>(backing);
    }

    @Override
    public List<T> multiGet(List<List<Object>> keys) {
        List<CachedBatchReadsMap.RetVal<TransactionalValue>> vals = this._backing.multiGet(keys);
        ArrayList ret = new ArrayList(vals.size());
        for (CachedBatchReadsMap.RetVal<TransactionalValue> retval : vals) {
            TransactionalValue v = (TransactionalValue)retval.val;
            if (v != null) {
                ret.add(v.getVal());
                continue;
            }
            ret.add(null);
        }
        return ret;
    }

    @Override
    public List<T> multiUpdate(List<List<Object>> keys, List<ValueUpdater> updaters) {
        List<CachedBatchReadsMap.RetVal<TransactionalValue>> curr = this._backing.multiGet(keys);
        ArrayList<TransactionalValue> newVals = new ArrayList<TransactionalValue>(curr.size());
        ArrayList<List<Object>> newKeys = new ArrayList<List<Object>>();
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < curr.size(); ++i) {
            TransactionalValue newVal;
            CachedBatchReadsMap.RetVal<TransactionalValue> retval = curr.get(i);
            TransactionalValue val = (TransactionalValue)retval.val;
            ValueUpdater updater = updaters.get(i);
            boolean changed = false;
            if (val == null) {
                newVal = new TransactionalValue<Object>(this._currTx, updater.update(null));
                changed = true;
            } else if (this._currTx != null && this._currTx.equals(val.getTxid()) && !retval.cached) {
                newVal = val;
            } else {
                newVal = new TransactionalValue(this._currTx, updater.update(val.getVal()));
                changed = true;
            }
            ret.add(newVal.getVal());
            if (!changed) continue;
            newVals.add(newVal);
            newKeys.add(keys.get(i));
        }
        if (!newKeys.isEmpty()) {
            this._backing.multiPut(newKeys, newVals);
        }
        return ret;
    }

    @Override
    public void multiPut(List<List<Object>> keys, List<T> vals) {
        ArrayList<TransactionalValue<T>> newVals = new ArrayList<TransactionalValue<T>>(vals.size());
        for (T val : vals) {
            newVals.add(new TransactionalValue<T>(this._currTx, val));
        }
        this._backing.multiPut(keys, newVals);
    }

    @Override
    public void beginCommit(Long txid) {
        this._currTx = txid;
        this._backing.reset();
    }

    @Override
    public void commit(Long txid) {
        this._currTx = null;
        this._backing.reset();
    }
}

