/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.storm.Config;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.topology.state.TransactionalState;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.WindowedTimeThrottler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterBatchCoordinator
extends BaseRichSpout {
    public static final Logger LOG = LoggerFactory.getLogger(MasterBatchCoordinator.class);
    public static final long INIT_TXID = 1L;
    public static final String BATCH_STREAM_ID = "$batch";
    public static final String COMMIT_STREAM_ID = "$commit";
    public static final String SUCCESS_STREAM_ID = "$success";
    private static final String CURRENT_TX = "currtx";
    private static final String CURRENT_ATTEMPTS = "currattempts";
    private List<TransactionalState> _states = new ArrayList<TransactionalState>();
    TreeMap<Long, TransactionStatus> _activeTx = new TreeMap();
    TreeMap<Long, Integer> _attemptIds;
    private SpoutOutputCollector _collector;
    Long _currTransaction;
    int _maxTransactionActive;
    List<ITridentSpout.BatchCoordinator> _coordinators = new ArrayList<ITridentSpout.BatchCoordinator>();
    List<String> _managedSpoutIds;
    List<ITridentSpout> _spouts;
    WindowedTimeThrottler _throttler;
    boolean _active = true;

    public MasterBatchCoordinator(List<String> spoutIds, List<ITridentSpout> spouts) {
        if (spoutIds.isEmpty()) {
            throw new IllegalArgumentException("Must manage at least one spout");
        }
        this._managedSpoutIds = spoutIds;
        this._spouts = spouts;
        LOG.debug("Created {}", (Object)this);
    }

    public List<String> getManagedSpoutIds() {
        return this._managedSpoutIds;
    }

    @Override
    public void activate() {
        this._active = true;
    }

    @Override
    public void deactivate() {
        this._active = false;
    }

    @Override
    public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector collector) {
        this._throttler = new WindowedTimeThrottler((Number)conf.get("topology.trident.batch.emit.interval.millis"), 1);
        for (String spoutId : this._managedSpoutIds) {
            this._states.add(TransactionalState.newCoordinatorState(conf, spoutId));
        }
        this._currTransaction = this.getStoredCurrTransaction();
        this._collector = collector;
        Number active = (Number)conf.get("topology.max.spout.pending");
        this._maxTransactionActive = active == null ? 1 : active.intValue();
        this._attemptIds = this.getStoredCurrAttempts(this._currTransaction, this._maxTransactionActive);
        for (int i = 0; i < this._spouts.size(); ++i) {
            String txId = this._managedSpoutIds.get(i);
            this._coordinators.add(this._spouts.get(i).getCoordinator(txId, conf, context));
        }
        LOG.debug("Opened {}", (Object)this);
    }

    @Override
    public void close() {
        for (TransactionalState state : this._states) {
            state.close();
        }
        LOG.debug("Closed {}", (Object)this);
    }

    @Override
    public void nextTuple() {
        this.sync();
    }

    @Override
    public void ack(Object msgId) {
        TransactionAttempt tx = (TransactionAttempt)msgId;
        TransactionStatus status = this._activeTx.get(tx.getTransactionId());
        LOG.debug("Ack. [tx_attempt = {}], [tx_status = {}], [{}]", new Object[]{tx, status, this});
        if (status != null && tx.equals(status.attempt)) {
            if (status.status == AttemptStatus.PROCESSING) {
                status.status = AttemptStatus.PROCESSED;
                LOG.debug("Changed status. [tx_attempt = {}] [tx_status = {}]", (Object)tx, (Object)status);
            } else if (status.status == AttemptStatus.COMMITTING) {
                this._activeTx.remove(tx.getTransactionId());
                this._attemptIds.remove(tx.getTransactionId());
                this._collector.emit(SUCCESS_STREAM_ID, new Values(tx));
                this._currTransaction = this.nextTransactionId(tx.getTransactionId());
                for (TransactionalState state : this._states) {
                    state.setData(CURRENT_TX, this._currTransaction);
                }
                LOG.debug("Emitted on [stream = {}], [tx_attempt = {}], [tx_status = {}], [{}]", new Object[]{SUCCESS_STREAM_ID, tx, status, this});
            }
            this.sync();
        }
    }

    @Override
    public void fail(Object msgId) {
        TransactionAttempt tx = (TransactionAttempt)msgId;
        TransactionStatus stored = this._activeTx.remove(tx.getTransactionId());
        LOG.debug("Fail. [tx_attempt = {}], [tx_status = {}], [{}]", new Object[]{tx, stored, this});
        if (stored != null && tx.equals(stored.attempt)) {
            this._activeTx.tailMap(tx.getTransactionId()).clear();
            this.sync();
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declareStream(BATCH_STREAM_ID, new Fields("tx"));
        declarer.declareStream(COMMIT_STREAM_ID, new Fields("tx"));
        declarer.declareStream(SUCCESS_STREAM_ID, new Fields("tx"));
    }

    private void sync() {
        TransactionStatus maybeCommit = this._activeTx.get(this._currTransaction);
        if (maybeCommit != null && maybeCommit.status == AttemptStatus.PROCESSED) {
            maybeCommit.status = AttemptStatus.COMMITTING;
            this._collector.emit(COMMIT_STREAM_ID, new Values(maybeCommit.attempt), maybeCommit.attempt);
            LOG.debug("Emitted on [stream = {}], [tx_status = {}], [{}]", new Object[]{COMMIT_STREAM_ID, maybeCommit, this});
        }
        if (this._active && this._activeTx.size() < this._maxTransactionActive) {
            Long curr = this._currTransaction;
            for (int i = 0; i < this._maxTransactionActive; ++i) {
                if (!this._activeTx.containsKey(curr) && this.isReady(curr)) {
                    Integer attemptId = this._attemptIds.get(curr);
                    if (attemptId == null) {
                        attemptId = 0;
                    } else {
                        Integer n = attemptId;
                        Integer n2 = attemptId = Integer.valueOf(attemptId + 1);
                    }
                    this._attemptIds.put(curr, attemptId);
                    for (TransactionalState state : this._states) {
                        state.setData(CURRENT_ATTEMPTS, this._attemptIds);
                    }
                    TransactionAttempt attempt = new TransactionAttempt(curr, attemptId);
                    TransactionStatus newTransactionStatus = new TransactionStatus(attempt);
                    this._activeTx.put(curr, newTransactionStatus);
                    this._collector.emit(BATCH_STREAM_ID, new Values(attempt), attempt);
                    LOG.debug("Emitted on [stream = {}], [tx_attempt = {}], [tx_status = {}], [{}]", new Object[]{BATCH_STREAM_ID, attempt, newTransactionStatus, this});
                    this._throttler.markEvent();
                }
                curr = this.nextTransactionId(curr);
            }
        }
    }

    private boolean isReady(long txid) {
        if (this._throttler.isThrottled()) {
            return false;
        }
        for (ITridentSpout.BatchCoordinator coord : this._coordinators) {
            if (!coord.isReady(txid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        Config ret = new Config();
        ret.setMaxTaskParallelism(1);
        ret.registerSerialization(TransactionAttempt.class);
        return ret;
    }

    private Long nextTransactionId(Long id) {
        return id + 1L;
    }

    private Long getStoredCurrTransaction() {
        Long ret = 1L;
        for (TransactionalState state : this._states) {
            Long curr = (Long)state.getData(CURRENT_TX);
            if (curr == null || curr.compareTo(ret) <= 0) continue;
            ret = curr;
        }
        return ret;
    }

    private TreeMap<Long, Integer> getStoredCurrAttempts(long currTransaction, int maxBatches) {
        TreeMap<Long, Integer> ret = new TreeMap<Long, Integer>();
        for (TransactionalState state : this._states) {
            HashMap attempts = (HashMap)state.getData(CURRENT_ATTEMPTS);
            if (attempts == null) {
                attempts = new HashMap();
            }
            for (Map.Entry e : attempts.entrySet()) {
                Number txidObj = e.getKey() instanceof String ? (Number)Long.parseLong((String)e.getKey()) : (Number)((Number)e.getKey());
                long txid = txidObj.longValue();
                int attemptId = ((Number)e.getValue()).intValue();
                Integer curr = ret.get(txid);
                if (curr != null && attemptId <= curr) continue;
                ret.put(txid, attemptId);
            }
        }
        ret.headMap(currTransaction).clear();
        ret.tailMap(currTransaction + (long)maxBatches - 1L).clear();
        return ret;
    }

    public String toString() {
        return "MasterBatchCoordinator{_states=" + this._states + ", _activeTx=" + this._activeTx + ", _attemptIds=" + this._attemptIds + ", _collector=" + this._collector + ", _currTransaction=" + this._currTransaction + ", _maxTransactionActive=" + this._maxTransactionActive + ", _coordinators=" + this._coordinators + ", _managedSpoutIds=" + this._managedSpoutIds + ", _spouts=" + this._spouts + ", _throttler=" + this._throttler + ", _active=" + this._active + "}";
    }

    private static class TransactionStatus {
        TransactionAttempt attempt;
        AttemptStatus status;

        public TransactionStatus(TransactionAttempt attempt) {
            this.attempt = attempt;
            this.status = AttemptStatus.PROCESSING;
        }

        public String toString() {
            return this.attempt.toString() + " <" + this.status.toString() + ">";
        }
    }

    private static enum AttemptStatus {
        PROCESSING,
        PROCESSED,
        COMMITTING;

    }
}

