/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.windowing;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public interface WindowsStore
extends Serializable {
    public static final String KEY_SEPARATOR = "|";

    public Object get(String var1);

    public Iterable<Object> get(List<String> var1);

    public Iterable<String> getAllKeys();

    public void put(String var1, Object var2);

    public void putAll(Collection<Entry> var1);

    public void remove(String var1);

    public void removeAll(Collection<String> var1);

    public void shutdown();

    public static class Entry
    implements Serializable {
        public final String key;
        public final Object value;

        public Entry(String key, Object value) {
            Entry.nonNullCheckForKey(key);
            Entry.nonNullCheckForValue(value);
            this.key = key;
            this.value = value;
        }

        public static void nonNullCheckForKey(Object key) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key argument can not be null");
        }

        public static void nonNullCheckForValue(Object value) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value argument can not be null");
        }
    }
}

