/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.exhibitor.DefaultExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.ExhibitorEnsembleProvider;
import org.apache.curator.ensemble.exhibitor.ExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.Exhibitors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.StormBoundedExponentialBackoffRetry;
import org.apache.storm.utils.ZookeeperAuthInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorUtils {
    public static final Logger LOG = LoggerFactory.getLogger(CuratorUtils.class);

    public static CuratorFramework newCurator(Map<String, Object> conf, List<String> servers, Object port, String root) {
        return CuratorUtils.newCurator(conf, servers, port, root, null);
    }

    public static CuratorFramework newCurator(Map<String, Object> conf, List<String> servers, Object port, ZookeeperAuthInfo auth) {
        return CuratorUtils.newCurator(conf, servers, port, "", auth);
    }

    public static CuratorFramework newCurator(Map<String, Object> conf, List<String> servers, Object port, String root, ZookeeperAuthInfo auth) {
        ArrayList<String> serverPorts = new ArrayList<String>();
        for (String zkServer : servers) {
            serverPorts.add(zkServer + ":" + ObjectReader.getInt(port));
        }
        String zkStr = StringUtils.join(serverPorts, (String)",") + root;
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        CuratorUtils.setupBuilder(builder, zkStr, conf, auth);
        return builder.build();
    }

    protected static void setupBuilder(CuratorFrameworkFactory.Builder builder, final String zkStr, Map<String, Object> conf, ZookeeperAuthInfo auth) {
        List<String> exhibitorServers = ObjectReader.getStrings(conf.get("storm.exhibitor.servers"));
        if (!exhibitorServers.isEmpty()) {
            builder.ensembleProvider((EnsembleProvider)new ExhibitorEnsembleProvider(new Exhibitors(exhibitorServers, ObjectReader.getInt(conf.get("storm.exhibitor.port")).intValue(), new Exhibitors.BackupConnectionStringProvider(){

                public String getBackupConnectionString() throws Exception {
                    return zkStr;
                }
            }), (ExhibitorRestClient)new DefaultExhibitorRestClient(), ObjectReader.getString(conf.get("storm.exhibitor.poll.uripath")), ObjectReader.getInt(conf.get("storm.exhibitor.poll.millis")).intValue(), (RetryPolicy)new StormBoundedExponentialBackoffRetry(ObjectReader.getInt(conf.get("storm.exhibitor.retry.interval")), ObjectReader.getInt(conf.get("storm.exhibitor.retry.intervalceiling.millis")), ObjectReader.getInt(conf.get("storm.exhibitor.retry.times")))));
        } else {
            builder.connectString(zkStr);
        }
        builder.connectionTimeoutMs(ObjectReader.getInt(conf.get("storm.zookeeper.connection.timeout")).intValue()).sessionTimeoutMs(ObjectReader.getInt(conf.get("storm.zookeeper.session.timeout")).intValue()).retryPolicy((RetryPolicy)new StormBoundedExponentialBackoffRetry(ObjectReader.getInt(conf.get("storm.zookeeper.retry.interval")), ObjectReader.getInt(conf.get("storm.zookeeper.retry.intervalceiling.millis")), ObjectReader.getInt(conf.get("storm.zookeeper.retry.times"))));
        if (auth != null && auth.scheme != null && auth.payload != null) {
            builder.authorization(auth.scheme, auth.payload);
        }
    }

    public static void testSetupBuilder(CuratorFrameworkFactory.Builder builder, String zkStr, Map<String, Object> conf, ZookeeperAuthInfo auth) {
        CuratorUtils.setupBuilder(builder, zkStr, conf, auth);
    }

    public static CuratorFramework newCuratorStarted(Map<String, Object> conf, List<String> servers, Object port, String root, ZookeeperAuthInfo auth) {
        CuratorFramework ret = CuratorUtils.newCurator(conf, servers, port, root, auth);
        LOG.info("Starting Utils Curator...");
        ret.start();
        return ret;
    }

    public static CuratorFramework newCuratorStarted(Map<String, Object> conf, List<String> servers, Object port, ZookeeperAuthInfo auth) {
        CuratorFramework ret = CuratorUtils.newCurator(conf, servers, port, auth);
        LOG.info("Starting Utils Curator (2)...");
        ret.start();
        return ret;
    }
}

