/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.ILocalDRPC;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.DRPCExecutionException;
import org.apache.storm.generated.DistributedRPC;
import org.apache.storm.security.auth.ThriftClient;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class DRPCClient
extends ThriftClient
implements DistributedRPC.Iface {
    private static volatile ILocalDRPC _localOverrideClient = null;
    private DistributedRPC.Iface client;
    private String host;
    private int port;

    public static boolean isLocalOverride() {
        return _localOverrideClient != null;
    }

    public static String getOverrideServiceId() {
        return _localOverrideClient.getServiceId();
    }

    public static DRPCClient getConfiguredClient(Map<String, Object> conf) throws TTransportException {
        ILocalDRPC override = _localOverrideClient;
        if (override != null) {
            return new DRPCClient(override);
        }
        List servers = (List)conf.get("drpc.servers");
        Collections.shuffle(servers);
        String host = (String)servers.get(0);
        int port = Integer.parseInt(conf.get("drpc.port").toString());
        return new DRPCClient(conf, host, port);
    }

    private DRPCClient(DistributedRPC.Iface override) {
        super(new HashMap<String, Object>(), ThriftConnectionType.LOCAL_FAKE, "localhost", 1234, null, null);
        this.host = "localhost";
        this.port = 1234;
        this.client = override;
    }

    public DRPCClient(Map<String, Object> conf, String host, int port) throws TTransportException {
        this(conf, host, port, null);
        this._retryForever = true;
    }

    public DRPCClient(Map<String, Object> conf, String host, int port, Integer timeout) throws TTransportException {
        super(conf, _localOverrideClient != null ? ThriftConnectionType.LOCAL_FAKE : ThriftConnectionType.DRPC, host, port, timeout, null);
        this.host = host;
        this.port = port;
        this.client = _localOverrideClient != null ? _localOverrideClient : new DistributedRPC.Client(this._protocol);
        this._retryForever = true;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String execute(String func, String args) throws TException, DRPCExecutionException, AuthorizationException {
        return this.client.execute(func, args);
    }

    public DistributedRPC.Iface getClient() {
        return this.client;
    }

    public static class LocalOverride
    implements AutoCloseable {
        public LocalOverride(ILocalDRPC client) {
            _localOverrideClient = client;
        }

        @Override
        public void close() throws Exception {
            _localOverrideClient = null;
        }
    }
}

