/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InprocMessaging {
    private static Map<Integer, LinkedBlockingQueue<Object>> _queues = new HashMap<Integer, LinkedBlockingQueue<Object>>();
    private static ConcurrentMap<Integer, AtomicBoolean> _hasReader = new ConcurrentHashMap<Integer, AtomicBoolean>();
    private static int port = 1;
    private static final Logger LOG = LoggerFactory.getLogger(InprocMessaging.class);

    public static synchronized int acquireNewPort() {
        int ret = port++;
        return ret;
    }

    public static void sendMessage(int port, Object msg) {
        InprocMessaging.waitForReader(port);
        InprocMessaging.getQueue(port).add(msg);
    }

    public static void sendMessageNoWait(int port, Object msg) {
        InprocMessaging.getQueue(port).add(msg);
    }

    public static Object takeMessage(int port) throws InterruptedException {
        InprocMessaging.readerArrived(port);
        return InprocMessaging.getQueue(port).take();
    }

    public static Object pollMessage(int port) {
        InprocMessaging.readerArrived(port);
        return InprocMessaging.getQueue(port).poll();
    }

    private static AtomicBoolean getHasReader(int port) {
        AtomicBoolean ab = (AtomicBoolean)_hasReader.get(port);
        if (ab == null) {
            _hasReader.putIfAbsent(port, new AtomicBoolean(false));
            ab = (AtomicBoolean)_hasReader.get(port);
        }
        return ab;
    }

    public static void waitForReader(int port) {
        AtomicBoolean ab = InprocMessaging.getHasReader(port);
        long start = Time.currentTimeMillis();
        while (!ab.get()) {
            if (Time.isSimulating()) {
                Time.advanceTime(100L);
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Time.currentTimeMillis() - start <= 20000L) continue;
            LOG.error("DONE WAITING FOR READER AFTER {} ms", (Object)(Time.currentTimeMillis() - start));
            break;
        }
    }

    private static void readerArrived(int port) {
        InprocMessaging.getHasReader(port).set(true);
    }

    private static synchronized LinkedBlockingQueue<Object> getQueue(int port) {
        if (!_queues.containsKey(port)) {
            _queues.put(port, new LinkedBlockingQueue());
        }
        return _queues.get(port);
    }
}

