/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Semaphore;

public class KeyedRoundRobinQueue<V> {
    private final Object _lock = new Object();
    private Semaphore _size = new Semaphore(0);
    private Map<Object, Queue<V>> _queues = new HashMap<Object, Queue<V>>();
    private List<Object> _keyOrder = new ArrayList<Object>();
    private int _currIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object key, V val) {
        Object object = this._lock;
        synchronized (object) {
            Queue<V> queue = this._queues.get(key);
            if (queue == null) {
                queue = new LinkedList<V>();
                this._queues.put(key, queue);
                this._keyOrder.add(key);
            }
            queue.add(val);
        }
        this._size.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V take() throws InterruptedException {
        this._size.acquire();
        Object object = this._lock;
        synchronized (object) {
            Object key = this._keyOrder.get(this._currIndex);
            Queue<V> queue = this._queues.get(key);
            V ret = queue.remove();
            if (queue.isEmpty()) {
                this._keyOrder.remove(this._currIndex);
                this._queues.remove(key);
                this._currIndex = this._keyOrder.size() == 0 ? 0 : (this._currIndex %= this._keyOrder.size());
            } else {
                this._currIndex = (this._currIndex + 1) % this._keyOrder.size();
            }
            return ret;
        }
    }
}

