/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StateSpoutSpec;
import org.apache.storm.generated.StormTopology;

public class ThriftTopologyUtils {
    public static boolean isWorkerHook(StormTopology._Fields f) {
        return f.equals((Object)StormTopology._Fields.WORKER_HOOKS);
    }

    public static boolean isDependencies(StormTopology._Fields f) {
        return f.equals((Object)StormTopology._Fields.DEPENDENCY_JARS) || f.equals((Object)StormTopology._Fields.DEPENDENCY_ARTIFACTS);
    }

    public static Set<String> getComponentIds(StormTopology topology) {
        HashSet<String> ret = new HashSet<String>();
        for (StormTopology._Fields f : StormTopology.metaDataMap.keySet()) {
            if (StormTopology.metaDataMap.get((Object)((Object)f)).valueMetaData.type != 13) continue;
            Map componentMap = (Map)topology.getFieldValue(f);
            ret.addAll(componentMap.keySet());
        }
        return ret;
    }

    public static ComponentCommon getComponentCommon(StormTopology topology, String componentId) {
        for (StormTopology._Fields f : StormTopology.metaDataMap.keySet()) {
            Map componentMap;
            if (StormTopology.metaDataMap.get((Object)((Object)f)).valueMetaData.type != 13 || !(componentMap = (Map)topology.getFieldValue(f)).containsKey(componentId)) continue;
            Object component = componentMap.get(componentId);
            if (component instanceof Bolt) {
                return ((Bolt)component).get_common();
            }
            if (component instanceof SpoutSpec) {
                return ((SpoutSpec)component).get_common();
            }
            if (component instanceof StateSpoutSpec) {
                return ((StateSpoutSpec)component).get_common();
            }
            throw new RuntimeException("Unreachable code! No get_common conversion for component " + component);
        }
        throw new IllegalArgumentException("Could not find component common for " + componentId);
    }
}

