/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Time {
    private static final Logger LOG = LoggerFactory.getLogger(Time.class);
    private static AtomicBoolean simulating = new AtomicBoolean(false);
    private static AtomicLong autoAdvanceNanosOnSleep = new AtomicLong(0L);
    private static volatile Map<Thread, AtomicLong> threadSleepTimesNanos;
    private static final Object sleepTimesLock;
    private static AtomicLong simulatedCurrTimeNanos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void startSimulating() {
        Object object = sleepTimesLock;
        synchronized (object) {
            simulating.set(true);
            simulatedCurrTimeNanos = new AtomicLong(0L);
            threadSleepTimesNanos = new ConcurrentHashMap<Thread, AtomicLong>();
            LOG.warn("Simulated Time Starting...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void stopSimulating() {
        Object object = sleepTimesLock;
        synchronized (object) {
            simulating.set(false);
            autoAdvanceNanosOnSleep.set(0L);
            threadSleepTimesNanos = null;
            LOG.warn("Simulated Time Ending...");
        }
    }

    public static boolean isSimulating() {
        return simulating.get();
    }

    public static void sleepUntil(long targetTimeMs) throws InterruptedException {
        if (simulating.get()) {
            Time.simulatedSleepUntilNanos(Time.millisToNanos(targetTimeMs));
        } else {
            long sleepTimeMs = targetTimeMs - Time.currentTimeMillis();
            if (sleepTimeMs > 0L) {
                Thread.sleep(sleepTimeMs);
            }
        }
    }

    public static void sleepUntilNanos(long targetTimeNanos) throws InterruptedException {
        if (simulating.get()) {
            Time.simulatedSleepUntilNanos(targetTimeNanos);
        } else {
            long sleepTimeNanos = targetTimeNanos - Time.nanoTime();
            long sleepTimeMs = Time.nanosToMillis(sleepTimeNanos);
            int sleepTimeNanosSansMs = (int)(sleepTimeNanos % 1000000L);
            if (sleepTimeNanos > 0L) {
                Thread.sleep(sleepTimeMs, sleepTimeNanosSansMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void simulatedSleepUntilNanos(long targetTimeNanos) throws InterruptedException {
        try {
            Object object = sleepTimesLock;
            synchronized (object) {
                if (threadSleepTimesNanos == null) {
                    LOG.debug("{} is still sleeping after simulated time disabled.", (Object)Thread.currentThread(), (Object)new RuntimeException("STACK TRACE"));
                    throw new InterruptedException();
                }
                threadSleepTimesNanos.put(Thread.currentThread(), new AtomicLong(targetTimeNanos));
            }
            while (simulatedCurrTimeNanos.get() < targetTimeNanos) {
                Object object2 = sleepTimesLock;
                synchronized (object2) {
                    if (threadSleepTimesNanos == null) {
                        LOG.debug("{} is still sleeping after simulated time disabled.", (Object)Thread.currentThread(), (Object)new RuntimeException("STACK TRACE"));
                        throw new InterruptedException();
                    }
                }
                long autoAdvance = autoAdvanceNanosOnSleep.get();
                if (autoAdvance > 0L) {
                    Time.advanceTimeNanos(autoAdvance);
                }
                Thread.sleep(10L);
            }
        }
        finally {
            Object object = sleepTimesLock;
            synchronized (object) {
                if (simulating.get() && threadSleepTimesNanos != null) {
                    threadSleepTimesNanos.remove(Thread.currentThread());
                }
            }
        }
    }

    public static void sleep(long ms) throws InterruptedException {
        Time.sleepUntil(Time.currentTimeMillis() + ms);
    }

    public static void sleepNanos(long nanos) throws InterruptedException {
        Time.sleepUntilNanos(Time.nanoTime() + nanos);
    }

    public static void sleepSecs(long secs) throws InterruptedException {
        if (secs > 0L) {
            Time.sleep(secs * 1000L);
        }
    }

    public static long nanoTime() {
        if (simulating.get()) {
            return simulatedCurrTimeNanos.get();
        }
        return System.nanoTime();
    }

    public static long currentTimeMillis() {
        if (simulating.get()) {
            return Time.nanosToMillis(simulatedCurrTimeNanos.get());
        }
        return System.currentTimeMillis();
    }

    public static long nanosToMillis(long nanos) {
        return nanos / 1000000L;
    }

    public static long millisToNanos(long millis) {
        return millis * 1000000L;
    }

    public static long secsToMillis(int secs) {
        return 1000L * (long)secs;
    }

    public static long secsToMillisLong(double secs) {
        return (long)(1000.0 * secs);
    }

    public static int currentTimeSecs() {
        return (int)(Time.currentTimeMillis() / 1000L);
    }

    public static int deltaSecs(int timeInSeconds) {
        return Time.currentTimeSecs() - timeInSeconds;
    }

    public static long deltaMs(long timeInMilliseconds) {
        return Time.currentTimeMillis() - timeInMilliseconds;
    }

    public static void advanceTime(long ms) {
        Time.advanceTimeNanos(Time.millisToNanos(ms));
    }

    public static void advanceTimeNanos(long nanos) {
        if (!simulating.get()) {
            throw new IllegalStateException("Cannot simulate time unless in simulation mode");
        }
        if (nanos < 0L) {
            throw new IllegalArgumentException("advanceTime only accepts positive time as an argument");
        }
        long newTime = simulatedCurrTimeNanos.addAndGet(nanos);
        LOG.debug("Advanced simulated time to {}", (Object)newTime);
    }

    public static void advanceTimeSecs(long secs) {
        Time.advanceTime(secs * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isThreadWaiting(Thread t) {
        AtomicLong time;
        if (!simulating.get()) {
            throw new IllegalStateException("Must be in simulation mode");
        }
        Object object = sleepTimesLock;
        synchronized (object) {
            time = threadSleepTimesNanos.get(t);
        }
        return !t.isAlive() || time != null && Time.nanoTime() < time.longValue();
    }

    static {
        sleepTimesLock = new Object();
    }

    public static class SimulatedTime
    implements AutoCloseable {
        public SimulatedTime() {
            this(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SimulatedTime(Number advanceTimeMs) {
            Object object = sleepTimesLock;
            synchronized (object) {
                simulating.set(true);
                simulatedCurrTimeNanos = new AtomicLong(0L);
                threadSleepTimesNanos = new ConcurrentHashMap();
                if (advanceTimeMs != null) {
                    autoAdvanceNanosOnSleep.set(Time.millisToNanos(advanceTimeMs.longValue()));
                }
                LOG.warn("AutoCloseable Simulated Time Starting...");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = sleepTimesLock;
            synchronized (object) {
                simulating.set(false);
                autoAdvanceNanosOnSleep.set(0L);
                threadSleepTimesNanos = null;
                LOG.warn("AutoCloseable Simulated Time Ending...");
            }
        }
    }
}

