/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import org.apache.storm.windowing.Event;
import org.apache.storm.windowing.EvictionContext;
import org.apache.storm.windowing.EvictionPolicy;

public class TimeEvictionPolicy<T>
implements EvictionPolicy<T> {
    private final int windowLength;
    protected EvictionContext evictionContext;

    public TimeEvictionPolicy(int windowLength) {
        this.windowLength = windowLength;
    }

    @Override
    public EvictionPolicy.Action evict(Event<T> event) {
        long now = this.evictionContext == null ? System.currentTimeMillis() : this.evictionContext.getReferenceTime();
        long diff = now - event.getTimestamp();
        if (diff >= (long)this.windowLength) {
            return EvictionPolicy.Action.EXPIRE;
        }
        return EvictionPolicy.Action.PROCESS;
    }

    @Override
    public void track(Event<T> event) {
    }

    @Override
    public void setContext(EvictionContext context) {
        this.evictionContext = context;
    }

    @Override
    public EvictionContext getContext() {
        return this.evictionContext;
    }

    public String toString() {
        return "TimeEvictionPolicy{windowLength=" + this.windowLength + ", evictionContext=" + this.evictionContext + '}';
    }
}

