/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import org.apache.storm.windowing.Event;
import org.apache.storm.windowing.EvictionPolicy;
import org.apache.storm.windowing.TimeEvictionPolicy;

public class WatermarkTimeEvictionPolicy<T>
extends TimeEvictionPolicy<T> {
    private final int lag;

    public WatermarkTimeEvictionPolicy(int windowLength) {
        this(windowLength, Integer.MAX_VALUE);
    }

    public WatermarkTimeEvictionPolicy(int windowLength, int lag) {
        super(windowLength);
        this.lag = lag;
    }

    @Override
    public EvictionPolicy.Action evict(Event<T> event) {
        long referenceTime = this.evictionContext.getReferenceTime() != null ? this.evictionContext.getReferenceTime() : 0L;
        long diff = referenceTime - event.getTimestamp();
        if (diff < (long)(-this.lag)) {
            return EvictionPolicy.Action.STOP;
        }
        if (diff < 0L) {
            return EvictionPolicy.Action.KEEP;
        }
        return super.evict(event);
    }

    @Override
    public String toString() {
        return "WatermarkTimeEvictionPolicy{lag=" + this.lag + "} " + super.toString();
    }
}

