/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.clojure;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.RT;
import clojure.lang.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.clojure.ClojureTuple;
import org.apache.storm.clojure.ClojureUtil;
import org.apache.storm.coordination.CoordinatedBolt;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.task.IBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;

public class ClojureBolt
implements IRichBolt,
CoordinatedBolt.FinishedCallback {
    Map<String, StreamInfo> _fields;
    List<String> _fnSpec;
    List<String> _confSpec;
    List<Object> _params;
    IBolt _bolt;

    public ClojureBolt(List fnSpec, List confSpec, List<Object> params, Map<String, StreamInfo> fields) {
        this._fnSpec = fnSpec;
        this._confSpec = confSpec;
        this._params = params;
        this._fields = fields;
    }

    public void prepare(final Map<String, Object> topoConf, final TopologyContext context, OutputCollector collector) {
        IFn hof = ClojureUtil.loadClojureFn(this._fnSpec.get(0), this._fnSpec.get(1));
        try {
            IFn preparer = (IFn)hof.applyTo(RT.seq(this._params));
            PersistentArrayMap collectorMap = new PersistentArrayMap(new Object[]{Keyword.intern((Symbol)Symbol.create((String)"output-collector")), collector, Keyword.intern((Symbol)Symbol.create((String)"context")), context});
            ArrayList<Object> args = new ArrayList<Object>((Map)collectorMap){
                final /* synthetic */ Map val$collectorMap;
                {
                    this.val$collectorMap = map2;
                    this.add(topoConf);
                    this.add(context);
                    this.add(this.val$collectorMap);
                }
            };
            this._bolt = (IBolt)preparer.applyTo(RT.seq((Object)args));
            try {
                this._bolt.prepare(topoConf, context, collector);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void execute(Tuple input) {
        this._bolt.execute((Tuple)new ClojureTuple(input));
    }

    public void cleanup() {
        try {
            this._bolt.cleanup();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (String stream : this._fields.keySet()) {
            StreamInfo info2 = this._fields.get(stream);
            declarer.declareStream(stream, info2.is_direct(), new Fields(info2.get_output_fields()));
        }
    }

    public void finishedId(Object id) {
        if (this._bolt instanceof CoordinatedBolt.FinishedCallback) {
            ((CoordinatedBolt.FinishedCallback)this._bolt).finishedId(id);
        }
    }

    public Map<String, Object> getComponentConfiguration() {
        IFn hof = ClojureUtil.loadClojureFn(this._confSpec.get(0), this._confSpec.get(1));
        try {
            return (Map)hof.applyTo(RT.seq(this._params));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

