/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.bolt;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.storm.hbase.bolt.AbstractHBaseBolt;
import org.apache.storm.hbase.bolt.mapper.HBaseMapper;
import org.apache.storm.hbase.bolt.mapper.HBaseProjectionCriteria;
import org.apache.storm.hbase.bolt.mapper.HBaseValueMapper;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseLookupBolt
extends AbstractHBaseBolt {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseLookupBolt.class);
    private HBaseValueMapper rowToTupleMapper;
    private HBaseProjectionCriteria projectionCriteria;
    private transient LoadingCache<byte[], Result> cache;
    private transient boolean cacheEnabled;

    public HBaseLookupBolt(String tableName, HBaseMapper mapper, HBaseValueMapper rowToTupleMapper) {
        super(tableName, mapper);
        Validate.notNull((Object)rowToTupleMapper, (String)"rowToTupleMapper can not be null");
        this.rowToTupleMapper = rowToTupleMapper;
    }

    public HBaseLookupBolt withConfigKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public HBaseLookupBolt withProjectionCriteria(HBaseProjectionCriteria projectionCriteria) {
        this.projectionCriteria = projectionCriteria;
        return this;
    }

    @Override
    public void prepare(Map<String, Object> config, TopologyContext topologyContext, OutputCollector collector) {
        super.prepare(config, topologyContext, collector);
        this.cacheEnabled = Boolean.parseBoolean(config.getOrDefault("hbase.cache.enable", "false").toString());
        int cacheTTL = Integer.parseInt(config.getOrDefault("hbase.cache.ttl.seconds", "300").toString());
        int maxCacheSize = Integer.parseInt(config.getOrDefault("hbase.cache.size", "1000").toString());
        if (this.cacheEnabled) {
            this.cache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).expireAfterWrite((long)cacheTTL, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<byte[], Result>(){

                public Result load(byte[] rowKey) throws Exception {
                    Get get = HBaseLookupBolt.this.hBaseClient.constructGetRequests(rowKey, HBaseLookupBolt.this.projectionCriteria);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cache miss for key:" + new String(rowKey));
                    }
                    return HBaseLookupBolt.this.hBaseClient.batchGet(Lists.newArrayList((Object[])new Get[]{get}))[0];
                }
            });
        }
    }

    public void execute(Tuple tuple) {
        if (TupleUtils.isTick((Tuple)tuple)) {
            this.collector.ack(tuple);
            return;
        }
        byte[] rowKey = this.mapper.rowKey(tuple);
        Result result = null;
        try {
            if (this.cacheEnabled) {
                result = (Result)this.cache.get((Object)rowKey);
            } else {
                Get get = this.hBaseClient.constructGetRequests(rowKey, this.projectionCriteria);
                result = this.hBaseClient.batchGet(Lists.newArrayList((Object[])new Get[]{get}))[0];
            }
            for (Values values : this.rowToTupleMapper.toValues((ITuple)tuple, result)) {
                this.collector.emit(tuple, (List)values);
            }
            this.collector.ack(tuple);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(tuple);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        this.rowToTupleMapper.declareOutputFields(outputFieldsDeclarer);
    }
}

