/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.bolt.mapper;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;

public class HBaseProjectionCriteria
implements Serializable {
    private List<byte[]> columnFamilies = Lists.newArrayList();
    private List<ColumnMetaData> columns = Lists.newArrayList();

    public HBaseProjectionCriteria addColumnFamily(String columnFamily) {
        this.columnFamilies.add(columnFamily.getBytes());
        return this;
    }

    public HBaseProjectionCriteria addColumn(ColumnMetaData column) {
        this.columns.add(column);
        return this;
    }

    public List<ColumnMetaData> getColumns() {
        return this.columns;
    }

    public List<byte[]> getColumnFamilies() {
        return this.columnFamilies;
    }

    public static class ColumnMetaData
    implements Serializable {
        private byte[] columnFamily;
        private byte[] qualifier;

        public ColumnMetaData(String columnFamily, String qualifier) {
            this.columnFamily = columnFamily.getBytes();
            this.qualifier = qualifier.getBytes();
        }

        public byte[] getColumnFamily() {
            return this.columnFamily;
        }

        public byte[] getQualifier() {
            return this.qualifier;
        }
    }
}

