/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.trident.windowing;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.storm.hbase.trident.windowing.HBaseWindowsStore;
import org.apache.storm.trident.windowing.WindowsStore;
import org.apache.storm.trident.windowing.WindowsStoreFactory;

public class HBaseWindowsStoreFactory
implements WindowsStoreFactory {
    private final Map<String, Object> config;
    private final String tableName;
    private final byte[] family;
    private final byte[] qualifier;

    public HBaseWindowsStoreFactory(Map<String, Object> config, String tableName, byte[] family, byte[] qualifier) {
        this.config = config;
        this.tableName = tableName;
        this.family = family;
        this.qualifier = qualifier;
    }

    public WindowsStore create(Map<String, Object> topoConf) {
        Configuration configuration = HBaseConfiguration.create();
        for (Map.Entry<String, Object> entry : this.config.entrySet()) {
            if (entry.getValue() == null) continue;
            configuration.set(entry.getKey(), entry.getValue().toString());
        }
        return new HBaseWindowsStore(topoConf, configuration, this.tableName, this.family, this.qualifier);
    }
}

