/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.common;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.tuple.Tuple;

public abstract class AbstractHDFSWriter {
    long lastUsedTime;
    long offset;
    boolean needsRotation;
    Path filePath;
    FileRotationPolicy rotationPolicy;

    AbstractHDFSWriter(FileRotationPolicy policy, Path path) {
        this.rotationPolicy = policy.copy();
        this.filePath = path;
    }

    public final long write(Tuple tuple) throws IOException {
        this.doWrite(tuple);
        this.needsRotation = this.rotationPolicy.mark(tuple, this.offset);
        return this.offset;
    }

    public final void sync() throws IOException {
        this.doSync();
    }

    public final void close() throws IOException {
        this.doClose();
    }

    public boolean needsRotation() {
        return this.needsRotation;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    protected abstract void doWrite(Tuple var1) throws IOException;

    protected abstract void doSync() throws IOException;

    protected abstract void doClose() throws IOException;
}

