/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.common;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.storm.hdfs.bolt.format.SequenceFormat;
import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.common.AbstractHDFSWriter;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFileWriter
extends AbstractHDFSWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceFileWriter.class);
    private SequenceFile.Writer writer;
    private SequenceFormat format;

    public SequenceFileWriter(FileRotationPolicy policy, Path path, SequenceFile.Writer writer, SequenceFormat format) {
        super(policy, path);
        this.writer = writer;
        this.format = format;
    }

    @Override
    protected void doWrite(Tuple tuple) throws IOException {
        this.writer.append(this.format.key(tuple), this.format.value(tuple));
        this.offset = this.writer.getLength();
    }

    @Override
    protected void doSync() throws IOException {
        LOG.debug("Attempting to sync all data to filesystem");
        this.writer.hsync();
    }

    @Override
    protected void doClose() throws IOException {
        this.writer.close();
    }
}

