/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.spout;

import java.io.PrintStream;
import java.util.TreeSet;
import org.apache.storm.hdfs.spout.FileOffset;

public class ProgressTracker {
    TreeSet<FileOffset> offsets = new TreeSet();

    public synchronized void recordAckedOffset(FileOffset newOffset) {
        if (newOffset == null) {
            return;
        }
        this.offsets.add(newOffset);
        FileOffset currHead = this.offsets.first();
        if (currHead.isNextOffset(newOffset)) {
            this.trimHead();
        }
    }

    private synchronized void trimHead() {
        FileOffset head2;
        if (this.offsets.size() <= 1) {
            return;
        }
        FileOffset head = this.offsets.first();
        if (head.isNextOffset(head2 = this.offsets.higher(head))) {
            this.offsets.pollFirst();
            this.trimHead();
        }
    }

    public synchronized FileOffset getCommitPosition() {
        if (!this.offsets.isEmpty()) {
            return this.offsets.first().clone();
        }
        return null;
    }

    public synchronized void dumpState(PrintStream stream) {
        stream.println(this.offsets);
    }

    public synchronized int size() {
        return this.offsets.size();
    }
}

