/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.trident.rotation;

import org.apache.storm.hdfs.trident.rotation.FileRotationPolicy;
import org.apache.storm.trident.tuple.TridentTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSizeRotationPolicy
implements FileRotationPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(FileSizeRotationPolicy.class);
    private long maxBytes;
    private long lastOffset = 0L;
    private long currentBytesWritten = 0L;

    public FileSizeRotationPolicy(float count, Units units) {
        this.maxBytes = (long)(count * (float)units.getByteCount());
    }

    @Override
    public boolean mark(TridentTuple tuple, long offset) {
        return this.mark(offset);
    }

    @Override
    public boolean mark(long offset) {
        long diff = offset - this.lastOffset;
        this.currentBytesWritten += diff;
        this.lastOffset = offset;
        return this.currentBytesWritten >= this.maxBytes;
    }

    @Override
    public void reset() {
        this.currentBytesWritten = 0L;
        this.lastOffset = 0L;
    }

    @Override
    public void start() {
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public static enum Units {
        KB((long)Math.pow(2.0, 10.0)),
        MB((long)Math.pow(2.0, 20.0)),
        GB((long)Math.pow(2.0, 30.0)),
        TB((long)Math.pow(2.0, 40.0));

        private long byteCount;

        private Units(long byteCount) {
            this.byteCount = byteCount;
        }

        public long getByteCount() {
            return this.byteCount;
        }
    }
}

