/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics.sigar;

import java.util.HashMap;
import org.apache.storm.metric.api.IMetric;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.Sigar;

public class CPUMetric
implements IMetric {
    private long _prevUser = 0L;
    private long _prevSys = 0L;
    private final Sigar _sigar = new Sigar();
    private final long _pid = this._sigar.getPid();

    public Object getValueAndReset() {
        try {
            ProcCpu cpu = this._sigar.getProcCpu(this._pid);
            long userTotal = cpu.getUser();
            long sysTotal = cpu.getSys();
            long user = userTotal - this._prevUser;
            long sys = sysTotal - this._prevSys;
            this._prevUser = userTotal;
            this._prevSys = sysTotal;
            HashMap<String, Long> ret = new HashMap<String, Long>();
            ret.put("user-ms", user);
            ret.put("sys-ms", sys);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

