/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.bolt;

import java.util.List;
import org.apache.storm.redis.bolt.AbstractRedisBolt;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisFilterMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import redis.clients.jedis.JedisCommands;

public class RedisFilterBolt
extends AbstractRedisBolt {
    private final RedisFilterMapper filterMapper;
    private final RedisDataTypeDescription.RedisDataType dataType;
    private final String additionalKey;

    public RedisFilterBolt(JedisPoolConfig config, RedisFilterMapper filterMapper) {
        super(config);
        this.filterMapper = filterMapper;
        RedisDataTypeDescription dataTypeDescription = filterMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
        if (this.dataType == RedisDataTypeDescription.RedisDataType.SET && this.additionalKey == null) {
            throw new IllegalArgumentException("additionalKey should be defined");
        }
    }

    public RedisFilterBolt(JedisClusterConfig config, RedisFilterMapper filterMapper) {
        super(config);
        this.filterMapper = filterMapper;
        RedisDataTypeDescription dataTypeDescription = filterMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Tuple input) {
        String key = this.filterMapper.getKeyFromTuple((ITuple)input);
        JedisCommands jedisCommand = null;
        try {
            boolean found;
            jedisCommand = this.getInstance();
            switch (this.dataType) {
                case STRING: {
                    found = jedisCommand.exists(key);
                    break;
                }
                case SET: {
                    found = jedisCommand.sismember(this.additionalKey, key);
                    break;
                }
                case HASH: {
                    found = jedisCommand.hexists(this.additionalKey, key);
                    break;
                }
                case SORTED_SET: {
                    found = jedisCommand.zrank(this.additionalKey, key) != null;
                    break;
                }
                case HYPER_LOG_LOG: {
                    found = jedisCommand.pfcount(key) > 0L;
                    break;
                }
                case GEO: {
                    List geopos = jedisCommand.geopos(this.additionalKey, new String[]{key});
                    found = geopos != null && geopos.size() > 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot process such data type: " + (Object)((Object)this.dataType));
                }
            }
            if (found) {
                this.collector.emit(input, input.getValues());
            }
            this.collector.ack(input);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(input);
        }
        finally {
            this.returnInstance(jedisCommand);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.filterMapper.declareOutputFields(declarer);
    }
}

