/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.state;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.storm.redis.common.container.JedisCommandsInstanceContainer;
import org.apache.storm.redis.utils.RedisEncoder;
import org.apache.storm.state.Serializer;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class RedisKeyValueStateIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final String namespace;
    private final Iterator<Map.Entry<String, String>> pendingPrepareIterator;
    private final Iterator<Map.Entry<String, String>> pendingCommitIterator;
    private final RedisEncoder<K, V> decoder;
    private final JedisCommandsInstanceContainer jedisContainer;
    private final ScanParams scanParams;
    private Iterator<Map.Entry<String, String>> pendingIterator;
    private String cursor;
    private List<Map.Entry<String, String>> cachedResult;
    private int readPosition;

    public RedisKeyValueStateIterator(String namespace, JedisCommandsInstanceContainer jedisContainer, Iterator<Map.Entry<String, String>> pendingPrepareIterator, Iterator<Map.Entry<String, String>> pendingCommitIterator, int chunkSize, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.namespace = namespace;
        this.pendingPrepareIterator = pendingPrepareIterator;
        this.pendingCommitIterator = pendingCommitIterator;
        this.jedisContainer = jedisContainer;
        this.decoder = new RedisEncoder<K, V>(keySerializer, valueSerializer);
        this.scanParams = new ScanParams().count(chunkSize);
        this.cursor = ScanParams.SCAN_POINTER_START;
    }

    @Override
    public boolean hasNext() {
        if (this.pendingPrepareIterator != null && this.pendingPrepareIterator.hasNext()) {
            this.pendingIterator = this.pendingPrepareIterator;
            return true;
        }
        if (this.pendingCommitIterator != null && this.pendingCommitIterator.hasNext()) {
            this.pendingIterator = this.pendingCommitIterator;
            return true;
        }
        this.pendingIterator = null;
        return !this.cursor.equals("0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map.Entry<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Map.Entry<String, String> redisKeyValue = null;
        if (this.pendingIterator != null) {
            redisKeyValue = this.pendingIterator.next();
        } else {
            if (this.cachedResult == null || this.readPosition >= this.cachedResult.size()) {
                JedisCommands commands = null;
                try {
                    commands = this.jedisContainer.getInstance();
                    ScanResult scanResult = commands.hscan(this.namespace, this.cursor, this.scanParams);
                    this.cachedResult = scanResult.getResult();
                    this.cursor = scanResult.getStringCursor();
                    this.readPosition = 0;
                }
                finally {
                    this.jedisContainer.returnInstance(commands);
                }
            }
            redisKeyValue = this.cachedResult.get(this.readPosition);
            ++this.readPosition;
        }
        K key = this.decoder.decodeKey(redisKeyValue.getKey());
        V value = this.decoder.decodeValue(redisKeyValue.getValue());
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

