/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident.state;

import java.util.Map;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisStoreMapper;
import org.apache.storm.redis.trident.state.AbstractRedisStateUpdater;
import org.apache.storm.redis.trident.state.RedisClusterState;
import redis.clients.jedis.JedisCluster;

public class RedisClusterStateUpdater
extends AbstractRedisStateUpdater<RedisClusterState> {
    public RedisClusterStateUpdater(RedisStoreMapper storeMapper) {
        super(storeMapper);
    }

    public RedisClusterStateUpdater withExpire(int expireIntervalSec) {
        this.setExpireInterval(expireIntervalSec);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateStatesToRedis(RedisClusterState redisClusterState, Map<String, String> keyToValue) {
        JedisCluster jedisCluster = null;
        try {
            jedisCluster = redisClusterState.getJedisCluster();
            block7: for (Map.Entry<String, String> kvEntry : keyToValue.entrySet()) {
                String key = kvEntry.getKey();
                String value = kvEntry.getValue();
                switch (this.dataType) {
                    case STRING: {
                        if (this.expireIntervalSec > 0) {
                            jedisCluster.setex(key, this.expireIntervalSec, value);
                            continue block7;
                        }
                        jedisCluster.set(key, value);
                        continue block7;
                    }
                    case HASH: {
                        jedisCluster.hset(this.additionalKey, key, value);
                        continue block7;
                    }
                }
                throw new IllegalArgumentException("Cannot process such data type: " + (Object)((Object)this.dataType));
            }
            if (this.dataType == RedisDataTypeDescription.RedisDataType.HASH && this.expireIntervalSec > 0) {
                jedisCluster.expire(this.additionalKey, this.expireIntervalSec);
            }
        }
        finally {
            if (jedisCluster != null) {
                redisClusterState.returnJedisCluster(jedisCluster);
            }
        }
    }
}

