/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.utils;

import com.google.common.base.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.storm.state.DefaultStateSerializer;
import org.apache.storm.state.Serializer;

public class RedisEncoder<K, V> {
    public static final Serializer<Optional<byte[]>> internalValueSerializer = new DefaultStateSerializer();
    public static final String TOMBSTONE = RedisEncoder.encode(internalValueSerializer.serialize((Object)Optional.absent()));
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;

    public RedisEncoder(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public String encodeKey(K key) {
        return RedisEncoder.encode(this.keySerializer.serialize(key));
    }

    public String encodeValue(V value) {
        return RedisEncoder.encode(internalValueSerializer.serialize((Object)Optional.of((Object)this.valueSerializer.serialize(value))));
    }

    public K decodeKey(String redisKey) {
        return (K)this.keySerializer.deserialize(RedisEncoder.decode(redisKey));
    }

    public V decodeValue(String redisValue) {
        Optional internalValue = (Optional)internalValueSerializer.deserialize(RedisEncoder.decode(redisValue));
        if (internalValue.isPresent()) {
            return (V)this.valueSerializer.deserialize((byte[])internalValue.get());
        }
        return null;
    }

    private static String encode(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    private static byte[] decode(String s) {
        return Base64.decodeBase64((String)s);
    }
}

