/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.nio.channels.ClosedByInterruptException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.BlobStoreUtils;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.nimbus.NimbusInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(BlobSynchronizer.class);
    private CuratorFramework zkClient;
    private Map<String, Object> conf;
    private BlobStore blobStore;
    private Set<String> blobStoreKeySet = new HashSet<String>();
    private Set<String> zookeeperKeySet = new HashSet<String>();
    private NimbusInfo nimbusInfo;

    public BlobSynchronizer(BlobStore blobStore, Map<String, Object> conf) {
        this.blobStore = blobStore;
        this.conf = conf;
    }

    public void setNimbusInfo(NimbusInfo nimbusInfo) {
        this.nimbusInfo = nimbusInfo;
    }

    public void setZookeeperKeySet(Set<String> zookeeperKeySet) {
        this.zookeeperKeySet = zookeeperKeySet;
    }

    public void setBlobStoreKeySet(Set<String> blobStoreKeySet) {
        this.blobStoreKeySet = blobStoreKeySet;
    }

    public Set<String> getBlobStoreKeySet() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.blobStoreKeySet);
        return keySet;
    }

    public Set<String> getZookeeperKeySet() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.zookeeperKeySet);
        return keySet;
    }

    public synchronized void syncBlobs() {
        try {
            LOG.debug("Sync blobs - blobstore keys {}, zookeeper keys {}", this.getBlobStoreKeySet(), this.getZookeeperKeySet());
            this.zkClient = BlobStoreUtils.createZKClient(this.conf);
            this.deleteKeySetFromBlobStoreNotOnZookeeper(this.getBlobStoreKeySet(), this.getZookeeperKeySet());
            this.updateKeySetForBlobStore(this.getBlobStoreKeySet());
            Set<String> keySetToDownload = this.getKeySetToDownload(this.getBlobStoreKeySet(), this.getZookeeperKeySet());
            LOG.debug("Key set Blobstore-> Zookeeper-> DownloadSet {}-> {}-> {}", new Object[]{this.getBlobStoreKeySet(), this.getZookeeperKeySet(), keySetToDownload});
            for (String key : keySetToDownload) {
                try {
                    Set<NimbusInfo> nimbusInfoSet = BlobStoreUtils.getNimbodesWithLatestSequenceNumberOfBlob(this.zkClient, key);
                    LOG.debug("syncBlobs, key: {}, nimbusInfoSet: {}", (Object)key, nimbusInfoSet);
                    if (!BlobStoreUtils.downloadMissingBlob(this.conf, this.blobStore, key, nimbusInfoSet)) continue;
                    BlobStoreUtils.createStateInZookeeper(this.conf, key, this.nimbusInfo);
                }
                catch (KeyNotFoundException e) {
                    LOG.debug("Detected deletion for the key {} while downloading - skipping download", (Object)key);
                }
            }
            if (this.zkClient != null) {
                this.zkClient.close();
            }
        }
        catch (InterruptedException | ClosedByInterruptException exp) {
            LOG.error("Interrupt Exception {}", (Throwable)exp);
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    public void deleteKeySetFromBlobStoreNotOnZookeeper(Set<String> keySetBlobStore, Set<String> keySetZookeeper) throws Exception {
        if (keySetBlobStore.removeAll(keySetZookeeper) || keySetZookeeper.isEmpty() && !keySetBlobStore.isEmpty()) {
            LOG.debug("Key set to delete in blobstore {}", keySetBlobStore);
            for (String key : keySetBlobStore) {
                this.blobStore.deleteBlob(key, BlobStoreUtils.getNimbusSubject());
            }
        }
    }

    public void updateKeySetForBlobStore(Set<String> keySetBlobStore) {
        try {
            for (String key : keySetBlobStore) {
                LOG.debug("updating blob");
                BlobStoreUtils.updateKeyForBlobStore(this.conf, this.blobStore, this.zkClient, key, this.nimbusInfo);
            }
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    public Set<String> getKeySetToDownload(Set<String> blobStoreKeySet, Set<String> zookeeperKeySet) {
        zookeeperKeySet.removeAll(blobStoreKeySet);
        LOG.debug("Key list to download {}", zookeeperKeySet);
        return zookeeperKeySet;
    }
}

