/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.storm.blobstore.LocalFsBlobStoreFile;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBlobStoreImpl {
    private static final long FULL_CLEANUP_FREQ = 3600000L;
    private static final int BUCKETS = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(FileBlobStoreImpl.class);
    private static final Timer timer = new Timer("FileBlobStore cleanup thread", true);
    private File fullPath;
    private TimerTask cleanup = null;

    public FileBlobStoreImpl(File path, Map<String, Object> conf) throws IOException {
        LOG.info("Creating new blob store based in {}", (Object)path);
        this.fullPath = path;
        this.fullPath.mkdirs();
        Object shouldCleanup = conf.get("blobstore.cleanup.enable");
        if (ObjectReader.getBoolean((Object)shouldCleanup, (boolean)false)) {
            LOG.debug("Starting File blobstore cleaner");
            this.cleanup = new TimerTask(){

                @Override
                public void run() {
                    try {
                        FileBlobStoreImpl.this.fullCleanup(3600000L);
                    }
                    catch (IOException e) {
                        LOG.error("Error trying to cleanup", (Throwable)e);
                    }
                }
            };
            timer.scheduleAtFixedRate(this.cleanup, 0L, 3600000L);
        }
    }

    public Iterator<String> listKeys() throws IOException {
        return new KeyInHashDirIterator();
    }

    public LocalFsBlobStoreFile read(String key) throws IOException {
        return new LocalFsBlobStoreFile(this.getKeyDir(key), "data");
    }

    public LocalFsBlobStoreFile write(String key, boolean create) throws IOException {
        return new LocalFsBlobStoreFile(this.getKeyDir(key), true, create);
    }

    public boolean exists(String key) {
        return this.getKeyDir(key).exists();
    }

    public void deleteKey(String key) throws IOException {
        File keyDir = this.getKeyDir(key);
        LocalFsBlobStoreFile pf = new LocalFsBlobStoreFile(keyDir, "data");
        pf.delete();
        this.delete(keyDir);
    }

    private File getKeyDir(String key) {
        String hash = String.valueOf(Math.abs((long)key.hashCode()) % 1024L);
        File ret = new File(new File(this.fullPath, hash), key);
        LOG.debug("{} Looking for {} in {}", new Object[]{this.fullPath, key, hash});
        return ret;
    }

    public void fullCleanup(long age) throws IOException {
        long cleanUpIfBefore = System.currentTimeMillis() - age;
        KeyInHashDirIterator keys = new KeyInHashDirIterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            File keyDir = this.getKeyDir(key);
            Iterator<LocalFsBlobStoreFile> i = this.listBlobStoreFiles(keyDir);
            if (!i.hasNext()) {
                try {
                    keyDir.delete();
                }
                catch (Exception e) {
                    LOG.warn("Could not delete " + keyDir + " will try again later");
                }
            }
            while (i.hasNext()) {
                LocalFsBlobStoreFile f = i.next();
                if (!f.isTmp() || f.getModTime() > cleanUpIfBefore) continue;
                f.delete();
            }
        }
    }

    protected Iterator<LocalFsBlobStoreFile> listBlobStoreFiles(File path) throws IOException {
        ArrayList<LocalFsBlobStoreFile> ret = new ArrayList<LocalFsBlobStoreFile>();
        File[] files = path.listFiles();
        if (files != null) {
            for (File sub : files) {
                try {
                    ret.add(new LocalFsBlobStoreFile(sub.getParentFile(), sub.getName()));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Found an unexpected file in {} {}", (Object)path, (Object)sub.getName());
                }
            }
        }
        return ret.iterator();
    }

    protected Iterator<String> listKeys(File path) throws IOException {
        String[] files = path.list();
        if (files != null) {
            return Arrays.asList(files).iterator();
        }
        return new LinkedList().iterator();
    }

    protected void delete(File path) throws IOException {
        if (Files.exists(path.toPath(), new LinkOption[0])) {
            Files.walkFileTree(path.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public void shutdown() {
        if (this.cleanup != null) {
            this.cleanup.cancel();
            this.cleanup = null;
        }
    }

    public class KeyInHashDirIterator
    implements Iterator<String> {
        private int currentBucket = 0;
        private Iterator<String> it = null;
        private String next = null;

        public KeyInHashDirIterator() throws IOException {
            this.primeNext();
        }

        private void primeNext() throws IOException {
            while (this.it == null && this.currentBucket < 1024) {
                String name = String.valueOf(this.currentBucket);
                File dir = new File(FileBlobStoreImpl.this.fullPath, name);
                try {
                    this.it = FileBlobStoreImpl.this.listKeys(dir);
                }
                catch (FileNotFoundException e) {
                    this.it = null;
                }
                if (this.it == null || !this.it.hasNext()) {
                    this.it = null;
                    ++this.currentBucket;
                    continue;
                }
                this.next = this.it.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String current = this.next;
            this.next = null;
            if (this.it != null) {
                if (!this.it.hasNext()) {
                    this.it = null;
                    ++this.currentBucket;
                    try {
                        this.primeNext();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.next = this.it.next();
                }
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Delete Not Supported");
        }
    }
}

