/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.curator.framework.CuratorFramework;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.BlobStoreAclHandler;
import org.apache.storm.blobstore.BlobStoreFile;
import org.apache.storm.blobstore.BlobStoreUtils;
import org.apache.storm.blobstore.FileBlobStoreImpl;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.blobstore.LocalFsBlobStoreFile;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.utils.Utils;
import org.apache.thrift.TBase;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFsBlobStore
extends BlobStore {
    public static final Logger LOG = LoggerFactory.getLogger(LocalFsBlobStore.class);
    private static final String DATA_PREFIX = "data_";
    private static final String META_PREFIX = "meta_";
    protected BlobStoreAclHandler _aclHandler;
    private final String BLOBSTORE_SUBTREE = "/blobstore/";
    private NimbusInfo nimbusInfo;
    private FileBlobStoreImpl fbs;
    private final int allPermissions = 7;
    private Map<String, Object> conf;
    private CuratorFramework zkClient;

    public void prepare(Map<String, Object> conf, String overrideBase, NimbusInfo nimbusInfo) {
        this.conf = conf;
        this.nimbusInfo = nimbusInfo;
        this.zkClient = BlobStoreUtils.createZKClient(conf);
        if (overrideBase == null && (overrideBase = (String)conf.get("blobstore.dir")) == null) {
            overrideBase = (String)conf.get("storm.local.dir");
        }
        File baseDir = new File(overrideBase, "blobs");
        try {
            this.fbs = new FileBlobStoreImpl(baseDir, conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this._aclHandler = new BlobStoreAclHandler(conf);
    }

    public AtomicOutputStream createBlob(String key, SettableBlobMeta meta, Subject who) throws AuthorizationException, KeyAlreadyExistsException {
        LOG.debug("Creating Blob for key {}", (Object)key);
        LocalFsBlobStore.validateKey((String)key);
        this._aclHandler.normalizeSettableBlobMeta(key, meta, who, 7);
        BlobStoreAclHandler.validateSettableACLs((String)key, (List)meta.get_acl());
        this._aclHandler.hasPermissions(meta.get_acl(), 7, who, key);
        if (this.fbs.exists(DATA_PREFIX + key)) {
            throw new KeyAlreadyExistsException(key);
        }
        BlobStore.BlobStoreFileOutputStream mOut = null;
        try {
            mOut = new BlobStore.BlobStoreFileOutputStream((BlobStore)this, (BlobStoreFile)this.fbs.write(META_PREFIX + key, true));
            mOut.write(Utils.thriftSerialize((TBase)meta));
            mOut.close();
            mOut = null;
            BlobStore.BlobStoreFileOutputStream blobStoreFileOutputStream = new BlobStore.BlobStoreFileOutputStream((BlobStore)this, (BlobStoreFile)this.fbs.write(DATA_PREFIX + key, true));
            return blobStoreFileOutputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (mOut != null) {
                try {
                    mOut.cancel();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public AtomicOutputStream updateBlob(String key, Subject who) throws AuthorizationException, KeyNotFoundException {
        LocalFsBlobStore.validateKey((String)key);
        this.checkPermission(key, who, 2);
        try {
            return new BlobStore.BlobStoreFileOutputStream((BlobStore)this, (BlobStoreFile)this.fbs.write(DATA_PREFIX + key, false));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SettableBlobMeta getStoredBlobMeta(String key) throws KeyNotFoundException {
        InputStream in = null;
        try {
            int len;
            LocalFsBlobStoreFile pf = this.fbs.read(META_PREFIX + key);
            try {
                in = pf.getInputStream();
            }
            catch (FileNotFoundException fnf) {
                throw new KeyNotFoundException(key);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            in.close();
            in = null;
            SettableBlobMeta settableBlobMeta = (SettableBlobMeta)Utils.thriftDeserialize(SettableBlobMeta.class, (byte[])out.toByteArray());
            return settableBlobMeta;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ReadableBlobMeta getBlobMeta(String key, Subject who) throws AuthorizationException, KeyNotFoundException {
        LocalFsBlobStore.validateKey((String)key);
        if (!this.checkForBlobOrDownload(key)) {
            this.checkForBlobUpdate(key);
        }
        SettableBlobMeta meta = this.getStoredBlobMeta(key);
        this._aclHandler.validateUserCanReadMeta(meta.get_acl(), who, key);
        ReadableBlobMeta rbm = new ReadableBlobMeta();
        rbm.set_settable(meta);
        try {
            LocalFsBlobStoreFile pf = this.fbs.read(DATA_PREFIX + key);
            rbm.set_version(pf.getModTime());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return rbm;
    }

    public void setBlobMeta(String key, SettableBlobMeta meta, Subject who) throws AuthorizationException, KeyNotFoundException {
        LocalFsBlobStore.validateKey((String)key);
        this.checkForBlobOrDownload(key);
        this._aclHandler.normalizeSettableBlobMeta(key, meta, who, 4);
        BlobStoreAclHandler.validateSettableACLs((String)key, (List)meta.get_acl());
        SettableBlobMeta orig = this.getStoredBlobMeta(key);
        this._aclHandler.hasPermissions(orig.get_acl(), 4, who, key);
        BlobStore.BlobStoreFileOutputStream mOut = null;
        try {
            mOut = new BlobStore.BlobStoreFileOutputStream((BlobStore)this, (BlobStoreFile)this.fbs.write(META_PREFIX + key, false));
            mOut.write(Utils.thriftSerialize((TBase)meta));
            mOut.close();
            mOut = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (mOut != null) {
                try {
                    mOut.cancel();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void deleteBlob(String key, Subject who) throws AuthorizationException, KeyNotFoundException {
        LocalFsBlobStore.validateKey((String)key);
        if (!this._aclHandler.checkForValidUsers(who, 2)) {
            LOG.debug("Retrieving meta to get ACL info... key: {} subject: {}", (Object)key, (Object)who);
            try {
                this.checkPermission(key, who, 2);
            }
            catch (KeyNotFoundException e) {
                LOG.error("Error while retrieving meta from ZK or local... key: {} subject: {}", (Object)key, (Object)who);
                throw e;
            }
        } else {
            LOG.debug("Given subject is eligible to delete key without checking ACL, skipping... key: {} subject: {}", (Object)key, (Object)who);
        }
        try {
            this.deleteKeyIgnoringFileNotFound(DATA_PREFIX + key);
            this.deleteKeyIgnoringFileNotFound(META_PREFIX + key);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkPermission(String key, Subject who, int mask) throws KeyNotFoundException, AuthorizationException {
        this.checkForBlobOrDownload(key);
        SettableBlobMeta meta = this.getStoredBlobMeta(key);
        this._aclHandler.hasPermissions(meta.get_acl(), mask, who, key);
    }

    private void deleteKeyIgnoringFileNotFound(String key) throws IOException {
        try {
            this.fbs.deleteKey(key);
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                LOG.debug("Ignoring FileNotFoundException since we're about to delete such key... key: {}", (Object)key);
            }
            throw e;
        }
    }

    public InputStreamWithMeta getBlob(String key, Subject who) throws AuthorizationException, KeyNotFoundException {
        LocalFsBlobStore.validateKey((String)key);
        if (!this.checkForBlobOrDownload(key)) {
            this.checkForBlobUpdate(key);
        }
        SettableBlobMeta meta = this.getStoredBlobMeta(key);
        this._aclHandler.hasPermissions(meta.get_acl(), 1, who, key);
        try {
            return new BlobStore.BlobStoreFileInputStream((BlobStore)this, (BlobStoreFile)this.fbs.read(DATA_PREFIX + key));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<String> listKeys() {
        try {
            return new BlobStore.KeyTranslationIterator(this.fbs.listKeys(), DATA_PREFIX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
    }

    public int getBlobReplication(String key, Subject who) throws Exception {
        int replicationCount = 0;
        LocalFsBlobStore.validateKey((String)key);
        SettableBlobMeta meta = this.getStoredBlobMeta(key);
        this._aclHandler.hasPermissions(meta.get_acl(), 1, who, key);
        if (this.zkClient.checkExists().forPath("/blobstore/" + key) == null) {
            return 0;
        }
        try {
            replicationCount = ((List)this.zkClient.getChildren().forPath("/blobstore/" + key)).size();
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        return replicationCount;
    }

    public int updateBlobReplication(String key, int replication, Subject who) throws AuthorizationException, KeyNotFoundException {
        throw new UnsupportedOperationException("For local file system blob store the update blobs function does not work. Please use HDFS blob store to make this feature available.");
    }

    public synchronized boolean checkForBlobOrDownload(String key) throws KeyNotFoundException {
        boolean checkBlobDownload = false;
        try {
            Set<NimbusInfo> nimbusSet;
            List<String> keyList = BlobStoreUtils.getKeyListFromBlobStore(this);
            if (!keyList.contains(key) && this.zkClient.checkExists().forPath("/blobstore/" + key) != null && BlobStoreUtils.downloadMissingBlob(this.conf, this, key, nimbusSet = BlobStoreUtils.getNimbodesWithLatestSequenceNumberOfBlob(this.zkClient, key))) {
                LOG.debug("Updating blobs state");
                BlobStoreUtils.createStateInZookeeper(this.conf, key, this.nimbusInfo);
                checkBlobDownload = true;
            }
        }
        catch (KeyNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return checkBlobDownload;
    }

    public synchronized void checkForBlobUpdate(String key) {
        BlobStoreUtils.updateKeyForBlobStore(this.conf, this, this.zkClient, key, this.nimbusInfo);
    }

    public void fullCleanup(long age) throws IOException {
        this.fbs.fullCleanup(age);
    }
}

