/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import org.apache.storm.blobstore.BlobStoreFile;
import org.apache.storm.generated.SettableBlobMeta;

public class LocalFsBlobStoreFile
extends BlobStoreFile {
    private final String _key;
    private final boolean _isTmp;
    private final File _path;
    private Long _modTime = null;
    private final boolean _mustBeNew;
    private SettableBlobMeta meta;

    public LocalFsBlobStoreFile(File base, String name) {
        if ("data".equals(name)) {
            this._isTmp = false;
        } else {
            Matcher m = TMP_NAME_PATTERN.matcher(name);
            if (!m.matches()) {
                throw new IllegalArgumentException("File name does not match '" + name + "' !~ " + TMP_NAME_PATTERN);
            }
            this._isTmp = true;
        }
        this._key = base.getName();
        this._path = new File(base, name);
        this._mustBeNew = false;
    }

    public LocalFsBlobStoreFile(File base, boolean isTmp, boolean mustBeNew) {
        this._key = base.getName();
        this._isTmp = isTmp;
        this._mustBeNew = mustBeNew;
        this._path = this._isTmp ? new File(base, System.currentTimeMillis() + ".tmp") : new File(base, "data");
    }

    public void delete() throws IOException {
        this._path.delete();
    }

    public boolean isTmp() {
        return this._isTmp;
    }

    public String getKey() {
        return this._key;
    }

    public long getModTime() throws IOException {
        if (this._modTime == null) {
            this._modTime = this._path.lastModified();
        }
        return this._modTime;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isTmp()) {
            throw new IllegalStateException("Cannot read from a temporary part file.");
        }
        return new FileInputStream(this._path);
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.isTmp()) {
            throw new IllegalStateException("Can only write to a temporary part file.");
        }
        boolean success = false;
        try {
            success = this._path.createNewFile();
        }
        catch (IOException e) {
            this._path.getParentFile().mkdirs();
            success = this._path.createNewFile();
        }
        if (!success) {
            throw new IOException(this._path + " already exists");
        }
        return new FileOutputStream(this._path);
    }

    public void commit() throws IOException {
        if (!this.isTmp()) {
            throw new IllegalStateException("Can only write to a temporary part file.");
        }
        File dest = new File(this._path.getParentFile(), "data");
        if (this._mustBeNew) {
            Files.move(this._path.toPath(), dest.toPath(), StandardCopyOption.ATOMIC_MOVE);
        } else {
            Files.move(this._path.toPath(), dest.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void cancel() throws IOException {
        if (!this.isTmp()) {
            throw new IllegalStateException("Can only write to a temporary part file.");
        }
        this.delete();
    }

    public SettableBlobMeta getMetadata() {
        return this.meta;
    }

    public void setMetadata(SettableBlobMeta meta) {
        this.meta = meta;
    }

    public String toString() {
        return this._path + ":" + (this._isTmp ? "tmp" : "data") + ":" + this._key;
    }

    public long getFileLength() {
        return this._path.length();
    }
}

